/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.fusesource.jansi;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import org.jetbrains.kotlin.org.fusesource.jansi.AnsiOutputStream;
import org.jetbrains.kotlin.org.fusesource.jansi.WindowsAnsiOutputStream;
import org.jetbrains.kotlin.org.fusesource.jansi.internal.CLibrary;
import org.jetbrains.kotlin.org.fusesource.jansi.internal.Kernel32;

public class AnsiConsole {
    public static final PrintStream system_out = System.out;
    public static final PrintStream out;
    public static final PrintStream system_err;
    public static final PrintStream err;
    private static final boolean IS_WINDOWS;
    private static final boolean IS_CYGWIN;
    private static final boolean IS_MINGW;
    private static int installed;

    private AnsiConsole() {
    }

    public static OutputStream wrapOutputStream(OutputStream stream2) {
        try {
            return AnsiConsole.wrapOutputStream(stream2, CLibrary.STDOUT_FILENO);
        }
        catch (Throwable ignore) {
            return AnsiConsole.wrapOutputStream(stream2, 1);
        }
    }

    public static OutputStream wrapErrorOutputStream(OutputStream stream2) {
        try {
            return AnsiConsole.wrapOutputStream(stream2, CLibrary.STDERR_FILENO);
        }
        catch (Throwable ignore) {
            return AnsiConsole.wrapOutputStream(stream2, 2);
        }
    }

    public static OutputStream wrapOutputStream(OutputStream stream2, int fileno) {
        if (Boolean.getBoolean("jansi.passthrough")) {
            return stream2;
        }
        if (Boolean.getBoolean("jansi.strip")) {
            return new AnsiOutputStream(stream2);
        }
        if (IS_WINDOWS && !IS_CYGWIN && !IS_MINGW) {
            try {
                return new WindowsAnsiOutputStream(stream2);
            }
            catch (Throwable throwable) {
                return new AnsiOutputStream(stream2);
            }
        }
        try {
            boolean forceColored = Boolean.getBoolean("jansi.force");
            if (!forceColored && CLibrary.isatty(fileno) == 0) {
                return new AnsiOutputStream(stream2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new FilterOutputStream(stream2){

            @Override
            public void close() throws IOException {
                this.write(AnsiOutputStream.RESET_CODE);
                this.flush();
                super.close();
            }
        };
    }

    public static PrintStream out() {
        return out;
    }

    public static PrintStream err() {
        return err;
    }

    public static synchronized void systemInstall() {
        if (++installed == 1) {
            System.setOut(out);
            System.setErr(err);
        }
    }

    public static synchronized void systemUninstall() {
        if (--installed == 0) {
            System.setOut(system_out);
            System.setErr(system_err);
        }
    }

    static {
        system_err = System.err;
        IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
        IS_CYGWIN = IS_WINDOWS && System.getenv("PWD") != null && System.getenv("PWD").startsWith("/") && !"cygwin".equals(System.getenv("TERM"));
        IS_MINGW = IS_WINDOWS && System.getenv("MSYSTEM") != null && System.getenv("MSYSTEM").startsWith("MINGW");
        String charset = Charset.defaultCharset().name();
        if (IS_WINDOWS && !IS_CYGWIN && !IS_MINGW) {
            int codepage = Kernel32.GetConsoleOutputCP();
            if (Charset.isSupported("ms" + codepage)) {
                charset = "ms" + codepage;
            } else if (Charset.isSupported("cp" + codepage)) {
                charset = "cp" + codepage;
            }
        }
        try {
            out = new PrintStream(AnsiConsole.wrapOutputStream(system_out), false, charset);
            err = new PrintStream(AnsiConsole.wrapErrorOutputStream(system_err), false, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

