/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.geometry.Bridge;
import com.sun.j3d.utils.geometry.Clean;
import com.sun.j3d.utils.geometry.Desperate;
import com.sun.j3d.utils.geometry.Distance;
import com.sun.j3d.utils.geometry.EarClip;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.HeapNode;
import com.sun.j3d.utils.geometry.Left;
import com.sun.j3d.utils.geometry.ListNode;
import com.sun.j3d.utils.geometry.NoHash;
import com.sun.j3d.utils.geometry.Orientation;
import com.sun.j3d.utils.geometry.PntNode;
import com.sun.j3d.utils.geometry.Project;
import com.sun.j3d.utils.geometry.Simple;
import com.sun.j3d.utils.geometry.Triangle;
import java.util.Random;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class Triangulator {
    GeometryInfo gInfo = null;
    int[] faces = null;
    int[] loops = null;
    int[] chains = null;
    Point2f[] points = null;
    Triangle[] triangles = null;
    ListNode[] list = null;
    Random randomGen = null;
    int numPoints = 0;
    int maxNumPoints = 0;
    int numList = 0;
    int maxNumList = 0;
    int numLoops = 0;
    int maxNumLoops = 0;
    int numTriangles = 0;
    int maxNumTriangles = 0;
    int numFaces = 0;
    int numTexSets = 0;
    int firstNode = 0;
    int numChains = 0;
    int maxNumChains = 0;
    Point2f[] pUnsorted = null;
    int maxNumPUnsorted = 0;
    boolean noHashingEdges = false;
    boolean noHashingPnts = false;
    int loopMin;
    int loopMax;
    PntNode[] vtxList = null;
    int numVtxList = 0;
    int numReflex = 0;
    int reflexVertices;
    Distance[] distances = null;
    int maxNumDist = 0;
    Left[] leftMost = null;
    int maxNumLeftMost = 0;
    HeapNode[] heap = null;
    int numHeap = 0;
    int maxNumHeap = 0;
    int numZero = 0;
    int maxNumPolyArea = 0;
    double[] polyArea = null;
    int[] stripCounts = null;
    int[] vertexIndices = null;
    Point3f[] vertices = null;
    Object[] colors = null;
    Vector3f[] normals = null;
    boolean ccwLoop = true;
    boolean earsRandom = true;
    boolean earsSorted = true;
    int identCntr;
    double epsilon = 1.0E-12;
    static final double ZERO = 1.0E-8;
    static final int EARS_SEQUENCE = 0;
    static final int EARS_RANDOM = 1;
    static final int EARS_SORTED = 2;
    static final int INC_LIST_BK = 100;
    static final int INC_LOOP_BK = 20;
    static final int INC_TRI_BK = 50;
    static final int INC_POINT_BK = 100;
    static final int INC_DIST_BK = 50;
    private static final int DEBUG = 0;

    public Triangulator() {
        this.earsRandom = false;
        this.earsSorted = false;
    }

    public Triangulator(int n) {
        switch (n) {
            case 0: {
                this.earsRandom = false;
                this.earsSorted = false;
                break;
            }
            case 1: {
                this.randomGen = new Random();
                this.earsRandom = true;
                this.earsSorted = false;
                break;
            }
            case 2: {
                this.earsRandom = false;
                this.earsSorted = true;
                break;
            }
            default: {
                this.earsRandom = false;
                this.earsSorted = false;
            }
        }
    }

    public void triangulate(GeometryInfo geometryInfo) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        if (geometryInfo.getPrimitive() != 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("Triangulator0"));
        }
        geometryInfo.indexify();
        this.vertices = geometryInfo.getCoordinates();
        this.vertexIndices = (int[])(this.vertices != null ? geometryInfo.getCoordinateIndices() : null);
        this.colors = geometryInfo.getColors();
        this.normals = geometryInfo.getNormals();
        this.gInfo = geometryInfo;
        this.stripCounts = geometryInfo.getStripCounts();
        this.faces = geometryInfo.getContourCounts();
        if (this.faces == null) {
            if (this.stripCounts == null) {
                System.out.println("StripCounts is null! Don't know what to do.");
            }
            this.faces = new int[this.stripCounts.length];
            for (n3 = 0; n3 < this.stripCounts.length; ++n3) {
                this.faces[n3] = 1;
            }
        }
        this.numFaces = this.faces.length;
        this.numTexSets = this.gInfo.getTexCoordSetCount();
        this.maxNumLoops = 0;
        this.maxNumList = 0;
        this.maxNumPoints = 0;
        this.maxNumDist = 0;
        this.maxNumLeftMost = 0;
        this.maxNumPUnsorted = 0;
        for (n3 = 0; n3 < this.faces.length; ++n3) {
            this.maxNumLoops += this.faces[n3];
            n2 = 0;
            while (n2 < this.faces[n3]) {
                this.maxNumList += this.stripCounts[n4] + 1;
                ++n2;
                ++n4;
            }
        }
        this.maxNumList += 20;
        this.loops = new int[this.maxNumLoops];
        this.list = new ListNode[this.maxNumList];
        this.numVtxList = 0;
        this.numReflex = 0;
        this.numTriangles = 0;
        this.numChains = 0;
        this.numPoints = 0;
        this.numLoops = 0;
        this.numList = 0;
        n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < this.faces.length; ++n3) {
            n2 = 0;
            while (n2 < this.faces[n3]) {
                int n6 = this.makeLoopHeader();
                int n7 = this.loops[n6];
                for (int i = 0; i < this.stripCounts[n4]; ++i) {
                    this.list[this.numList] = new ListNode(this.vertexIndices[n5]);
                    ++this.numList;
                    this.insertAfter(n7, n);
                    this.list[n].setCommonIndex(n5);
                    n7 = n;
                    ++n5;
                }
                this.deleteHook(n6);
                ++n2;
                ++n4;
            }
        }
        this.maxNumTriangles = this.maxNumList / 2;
        this.triangles = new Triangle[this.maxNumTriangles];
        this.setEpsilon(1.0E-8);
        int n8 = 0;
        int n9 = 0;
        for (n2 = 0; n2 < this.numFaces; ++n2) {
            this.ccwLoop = true;
            blArray[0] = false;
            n9 = n8 + this.faces[n2];
            boolean bl3 = this.faces[n2] > 1 ? true : !Simple.simpleFace(this, this.loops[n8]);
            if (bl3) {
                int n10;
                for (n10 = 0; n10 < this.faces[n2]; ++n10) {
                    this.preProcessList(n8 + n10);
                }
                Project.projectFace(this, n8, n9);
                n10 = Clean.cleanPolyhedralFace(this, n8, n9);
                if (this.faces[n2] == 1) {
                    Orientation.determineOrientation(this, this.loops[n8]);
                } else {
                    Orientation.adjustOrientation(this, n8, n9);
                }
                if (this.faces[n2] > 1) {
                    NoHash.prepareNoHashEdges(this, n8, n9);
                } else {
                    this.noHashingEdges = false;
                    this.noHashingPnts = false;
                }
                for (n3 = n8; n3 < n9; ++n3) {
                    EarClip.classifyAngles(this, this.loops[n3]);
                }
                if (this.faces[n2] > 1) {
                    Bridge.constructBridges(this, n8, n9);
                }
                this.resetPolyList(this.loops[n8]);
                NoHash.prepareNoHashPnts(this, n8);
                EarClip.classifyEars(this, this.loops[n8]);
                blArray[0] = false;
                while (!blArray[0]) {
                    if (!EarClip.clipEar(this, blArray)) {
                        if (bl) {
                            n = this.getNode();
                            this.resetPolyList(n);
                            this.loops[n8] = n;
                            if (Desperate.desperate(this, n, n8, blArray)) {
                                if (!Desperate.letsHope(this, n)) {
                                    return;
                                }
                            } else {
                                bl = false;
                            }
                        } else {
                            bl2 = true;
                            n = this.getNode();
                            this.resetPolyList(n);
                            EarClip.classifyEars(this, n);
                            bl = true;
                        }
                    } else {
                        bl = false;
                    }
                    if (!blArray[0]) continue;
                    n = this.getNextChain(blArray2);
                    if (!blArray2[0]) continue;
                    this.resetPolyList(n);
                    this.loops[n8] = n;
                    this.noHashingPnts = false;
                    NoHash.prepareNoHashPnts(this, n8);
                    EarClip.classifyEars(this, n);
                    bl = false;
                    blArray[0] = false;
                }
            }
            n8 = n9;
        }
        this.writeTriangleToGeomInfo();
    }

    void printVtxList() {
        System.out.println("numReflex " + this.numReflex + " reflexVertices " + this.reflexVertices);
        for (int i = 0; i < this.numVtxList; ++i) {
            System.out.println(i + " pnt " + this.vtxList[i].pnt + ", next " + this.vtxList[i].next);
        }
    }

    void printListData() {
        for (int i = 0; i < this.numList; ++i) {
            System.out.println("list[" + i + "].index " + this.list[i].index + ", prev " + this.list[i].prev + ", next " + this.list[i].next + ", convex " + this.list[i].convex + ", vertexIndex " + this.list[i].vcntIndex);
        }
    }

    void preProcessList(int n) {
        int n2;
        this.resetPolyList(this.loops[n]);
        int n3 = n2 = this.loops[n];
        int n4 = this.list[n3].next;
        while (n4 != n2) {
            if (this.list[n3].index == this.list[n4].index) {
                if (n4 == this.loops[n]) {
                    this.loops[n] = this.list[n4].next;
                }
                this.deleteLinks(n4);
            }
            n3 = this.list[n3].next;
            n4 = this.list[n3].next;
        }
    }

    void writeTriangleToGeomInfo() {
        int[] nArray;
        int[] nArray2;
        int n;
        int n2;
        this.gInfo.setPrimitive(1);
        this.gInfo.setContourCounts(null);
        this.gInfo.forgetOldPrim();
        this.gInfo.setStripCounts(null);
        int n3 = 0;
        int[] nArray3 = new int[this.numTriangles * 3];
        for (n2 = 0; n2 < this.numTriangles; ++n2) {
            n = this.list[this.triangles[n2].v1].getCommonIndex();
            nArray3[n3++] = this.vertexIndices[n];
            n = this.list[this.triangles[n2].v2].getCommonIndex();
            nArray3[n3++] = this.vertexIndices[n];
            n = this.list[this.triangles[n2].v3].getCommonIndex();
            nArray3[n3++] = this.vertexIndices[n];
        }
        this.gInfo.setCoordinateIndices(nArray3);
        if (this.normals != null) {
            nArray2 = this.gInfo.getNormalIndices();
            nArray = new int[this.numTriangles * 3];
            n3 = 0;
            for (n2 = 0; n2 < this.numTriangles; ++n2) {
                n = this.list[this.triangles[n2].v1].getCommonIndex();
                nArray[n3++] = nArray2[n];
                n = this.list[this.triangles[n2].v2].getCommonIndex();
                nArray[n3++] = nArray2[n];
                n = this.list[this.triangles[n2].v3].getCommonIndex();
                nArray[n3++] = nArray2[n];
            }
            this.gInfo.setNormalIndices(nArray);
        }
        if (this.colors != null) {
            n3 = 0;
            nArray2 = this.gInfo.getColorIndices();
            nArray = new int[this.numTriangles * 3];
            for (n2 = 0; n2 < this.numTriangles; ++n2) {
                n = this.list[this.triangles[n2].v1].getCommonIndex();
                nArray[n3++] = nArray2[n];
                n = this.list[this.triangles[n2].v2].getCommonIndex();
                nArray[n3++] = nArray2[n];
                n = this.list[this.triangles[n2].v3].getCommonIndex();
                nArray[n3++] = nArray2[n];
            }
            this.gInfo.setColorIndices(nArray);
        }
        for (int i = 0; i < this.numTexSets; ++i) {
            nArray = new int[this.numTriangles * 3];
            int[] nArray4 = this.gInfo.getTextureCoordinateIndices(i);
            n3 = 0;
            for (n2 = 0; n2 < this.numTriangles; ++n2) {
                n = this.list[this.triangles[n2].v1].getCommonIndex();
                nArray[n3++] = nArray4[n];
                n = this.list[this.triangles[n2].v2].getCommonIndex();
                nArray[n3++] = nArray4[n];
                n = this.list[this.triangles[n2].v3].getCommonIndex();
                nArray[n3++] = nArray4[n];
            }
            this.gInfo.setTextureCoordinateIndices(i, nArray);
        }
    }

    void setEpsilon(double d) {
        this.epsilon = d;
    }

    boolean inPolyList(int n) {
        return n >= 0 && n < this.numList && this.numList <= this.maxNumList;
    }

    void updateIndex(int n, int n2) {
        this.list[n].index = n2;
    }

    int getAngle(int n) {
        return this.list[n].convex;
    }

    void setAngle(int n, int n2) {
        this.list[n].convex = n2;
    }

    void resetPolyList(int n) {
        this.firstNode = n;
    }

    int getNode() {
        return this.firstNode;
    }

    boolean inLoopList(int n) {
        return n >= 0 && n < this.numLoops && this.numLoops <= this.maxNumLoops;
    }

    void deleteHook(int n) {
        if (!this.inLoopList(n)) {
            System.out.println("Triangulator:deleteHook : Loop access out of range.");
        }
        int n2 = this.loops[n];
        int n3 = this.list[n2].next;
        if (this.inPolyList(n2) && this.inPolyList(n3)) {
            this.deleteLinks(n2);
            this.loops[n] = n3;
        } else {
            System.out.println("Triangulator:deleteHook : List access out of range.");
        }
    }

    void deleteLinks(int n) {
        if (this.inPolyList(n) && this.inPolyList(this.list[n].prev) && this.inPolyList(this.list[n].next)) {
            if (this.firstNode == n) {
                this.firstNode = this.list[n].next;
            }
            this.list[this.list[n].next].prev = this.list[n].prev;
            this.list[this.list[n].prev].next = this.list[n].next;
            this.list[n].prev = this.list[n].next = n;
        } else {
            System.out.println("Triangulator:deleteLinks : Access out of range.");
        }
    }

    void rotateLinks(int n, int n2) {
        int n3 = this.list[n].next;
        int n4 = this.list[n2].next;
        int n5 = this.list[n].next;
        this.list[n].next = this.list[n2].next;
        this.list[n2].next = n5;
        this.list[n3].prev = n2;
        this.list[n4].prev = n;
    }

    void storeChain(int n) {
        if (this.numChains >= this.maxNumChains) {
            this.maxNumChains += 20;
            int[] nArray = this.chains;
            this.chains = new int[this.maxNumChains];
            if (nArray != null) {
                System.arraycopy(nArray, 0, this.chains, 0, nArray.length);
            }
        }
        this.chains[this.numChains] = n;
        ++this.numChains;
    }

    int getNextChain(boolean[] blArray) {
        if (this.numChains > 0) {
            blArray[0] = true;
            --this.numChains;
            return this.chains[this.numChains];
        }
        blArray[0] = false;
        this.numChains = 0;
        return 0;
    }

    void splitSplice(int n, int n2, int n3, int n4) {
        this.list[n].next = n4;
        this.list[n4].prev = n;
        this.list[n2].prev = n3;
        this.list[n3].next = n2;
    }

    int makeHook() {
        int n = this.numList;
        if (this.numList >= this.maxNumList) {
            this.maxNumList += 100;
            ListNode[] listNodeArray = this.list;
            this.list = new ListNode[this.maxNumList];
            System.arraycopy(listNodeArray, 0, this.list, 0, listNodeArray.length);
        }
        this.list[this.numList] = new ListNode(-1);
        this.list[this.numList].prev = n;
        this.list[this.numList].next = n;
        this.list[this.numList].index = -1;
        ++this.numList;
        return n;
    }

    int makeLoopHeader() {
        int n = this.makeHook();
        if (this.numLoops >= this.maxNumLoops) {
            this.maxNumLoops += 20;
            int[] nArray = this.loops;
            this.loops = new int[this.maxNumLoops];
            System.arraycopy(nArray, 0, this.loops, 0, nArray.length);
        }
        this.loops[this.numLoops] = n;
        int n2 = this.numLoops++;
        return n2;
    }

    int makeNode(int n) {
        if (this.numList >= this.maxNumList) {
            this.maxNumList += 100;
            ListNode[] listNodeArray = this.list;
            this.list = new ListNode[this.maxNumList];
            System.arraycopy(listNodeArray, 0, this.list, 0, listNodeArray.length);
        }
        this.list[this.numList] = new ListNode(n);
        int n2 = this.numList;
        this.list[this.numList].index = n;
        this.list[this.numList].prev = -1;
        this.list[this.numList].next = -1;
        ++this.numList;
        return n2;
    }

    void insertAfter(int n, int n2) {
        if (this.inPolyList(n) && this.inPolyList(n2)) {
            this.list[n2].next = this.list[n].next;
            this.list[n2].prev = n;
            this.list[n].next = n2;
            int n3 = this.list[n2].next;
            if (this.inPolyList(n3)) {
                this.list[n3].prev = n2;
            } else {
                System.out.println("Triangulator:deleteHook : List access out of range.");
            }
            return;
        }
        System.out.println("Triangulator:deleteHook : List access out of range.");
    }

    int fetchNextData(int n) {
        return this.list[n].next;
    }

    int fetchData(int n) {
        return this.list[n].index;
    }

    int fetchPrevData(int n) {
        return this.list[n].prev;
    }

    void swapLinks(int n) {
        int n2 = this.list[n].next;
        this.list[n].next = this.list[n].prev;
        this.list[n].prev = n2;
        int n3 = n2;
        while (n2 != n) {
            n3 = this.list[n2].next;
            this.list[n2].next = this.list[n2].prev;
            this.list[n2].prev = n3;
            n2 = n3;
        }
    }

    void storeTriangle(int n, int n2, int n3) {
        if (this.numTriangles >= this.maxNumTriangles) {
            this.maxNumTriangles += 50;
            Triangle[] triangleArray = this.triangles;
            this.triangles = new Triangle[this.maxNumTriangles];
            if (triangleArray != null) {
                System.arraycopy(triangleArray, 0, this.triangles, 0, triangleArray.length);
            }
        }
        this.triangles[this.numTriangles] = this.ccwLoop ? new Triangle(n, n2, n3) : new Triangle(n2, n, n3);
        ++this.numTriangles;
    }

    void initPnts(int n) {
        if (this.maxNumPoints < n) {
            this.maxNumPoints = n;
            this.points = new Point2f[this.maxNumPoints];
        }
        for (int i = 0; i < n; ++i) {
            this.points[i] = new Point2f(0.0f, 0.0f);
        }
        this.numPoints = 0;
    }

    boolean inPointsList(int n) {
        return n >= 0 && n < this.numPoints && this.numPoints <= this.maxNumPoints;
    }

    int storePoint(double d, double d2) {
        if (this.numPoints >= this.maxNumPoints) {
            this.maxNumPoints += 100;
            Point2f[] point2fArray = this.points;
            this.points = new Point2f[this.maxNumPoints];
            if (point2fArray != null) {
                System.arraycopy(point2fArray, 0, this.points, 0, point2fArray.length);
            }
        }
        this.points[this.numPoints] = new Point2f((float)d, (float)d2);
        int n = this.numPoints++;
        return n;
    }
}

