/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry.compression;

import com.sun.j3d.utils.geometry.compression.CommandStream;
import com.sun.j3d.utils.geometry.compression.HuffmanNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;

class HuffmanTable {
    private static final int MAX_TAG_LENGTH = 6;
    private HuffmanNode[] positions;
    private HuffmanNode[] normals;
    private HuffmanNode[] colors = new HuffmanNode[544];

    HuffmanTable() {
        this.positions = new HuffmanNode[544];
        this.normals = new HuffmanNode[112];
    }

    private final int getPositionIndex(int n, int n2, boolean bl) {
        return (bl ? 1 : 0) * 272 + n * 16 + n2;
    }

    private final int getNormalIndex(int n, int n2, boolean bl) {
        return (bl ? 1 : 0) * 56 + n * 7 + n2;
    }

    private final int getColorIndex(int n, int n2, boolean bl) {
        return this.getPositionIndex(n, n2, bl);
    }

    void addPositionEntry(int n, int n2, boolean bl) {
        this.addEntry(this.positions, this.getPositionIndex(n, n2, bl), n, n2, bl);
    }

    HuffmanNode getPositionEntry(int n, int n2, boolean bl) {
        return this.getEntry(this.positions, this.getPositionIndex(n, n2, bl));
    }

    void addColorEntry(int n, int n2, boolean bl) {
        this.addEntry(this.colors, this.getColorIndex(n, n2, bl), n, n2, bl);
    }

    HuffmanNode getColorEntry(int n, int n2, boolean bl) {
        return this.getEntry(this.colors, this.getColorIndex(n, n2, bl));
    }

    void addNormalEntry(int n, int n2, boolean bl) {
        this.addEntry(this.normals, this.getNormalIndex(n, n2, bl), n, n2, bl);
    }

    HuffmanNode getNormalEntry(int n, int n2, boolean bl) {
        return this.getEntry(this.normals, this.getNormalIndex(n, n2, bl));
    }

    private void addEntry(HuffmanNode[] huffmanNodeArray, int n, int n2, int n3, boolean bl) {
        if (huffmanNodeArray[n] == null) {
            huffmanNodeArray[n] = new HuffmanNode(n2, n3, bl);
        } else if (huffmanNodeArray[n].cleared()) {
            huffmanNodeArray[n].set(n2, n3, bl);
        }
        huffmanNodeArray[n].addCount();
    }

    private HuffmanNode getEntry(HuffmanNode[] huffmanNodeArray, int n) {
        HuffmanNode huffmanNode = huffmanNodeArray[n];
        while (huffmanNode.merged()) {
            huffmanNode = huffmanNode.getMergeNode();
        }
        return huffmanNode;
    }

    private void getEntries(HuffmanNode[] huffmanNodeArray, Collection collection) {
        for (int i = 0; i < huffmanNodeArray.length; ++i) {
            if (huffmanNodeArray[i] == null || huffmanNodeArray[i].cleared() || !huffmanNodeArray[i].hasCount() || huffmanNodeArray[i].merged()) continue;
            collection.add(huffmanNodeArray[i]);
        }
    }

    void clear() {
        int n;
        for (n = 0; n < this.positions.length; ++n) {
            if (this.positions[n] == null) continue;
            this.positions[n].clear();
        }
        for (n = 0; n < this.colors.length; ++n) {
            if (this.colors[n] == null) continue;
            this.colors[n].clear();
        }
        for (n = 0; n < this.normals.length; ++n) {
            if (this.normals[n] == null) continue;
            this.normals[n].clear();
        }
    }

    void computeTags() {
        LinkedList linkedList = new LinkedList();
        this.getEntries(this.positions, linkedList);
        this.computeTags(linkedList, 3);
        linkedList.clear();
        this.getEntries(this.colors, linkedList);
        this.computeTags(linkedList, 3);
        linkedList.clear();
        this.getEntries(this.normals, linkedList);
        this.computeTags(linkedList, 2);
    }

    private void computeTags(LinkedList linkedList, int n) {
        if (linkedList.isEmpty()) {
            return;
        }
        while (true) {
            Collections.sort(linkedList, HuffmanNode.frequencyComparator);
            HuffmanNode huffmanNode = (HuffmanNode)linkedList.removeFirst();
            while (linkedList.size() > 0) {
                HuffmanNode huffmanNode2 = (HuffmanNode)linkedList.removeFirst();
                HuffmanNode huffmanNode3 = new HuffmanNode();
                huffmanNode3.addChildren(huffmanNode, huffmanNode2);
                this.addNodeInOrder(linkedList, huffmanNode3, HuffmanNode.frequencyComparator);
                huffmanNode = (HuffmanNode)linkedList.removeFirst();
            }
            huffmanNode.collectLeaves(0, 0, linkedList);
            Collections.sort(linkedList, HuffmanNode.tagLengthComparator);
            if (((HuffmanNode)linkedList.getFirst()).tagLength <= 6) break;
            this.merge(linkedList);
        }
        this.expand(linkedList, n);
    }

    private void merge(LinkedList linkedList) {
        ListIterator<HuffmanNode> listIterator = linkedList.listIterator(0);
        boolean bl = false;
        while (listIterator.hasNext()) {
            HuffmanNode huffmanNode = (HuffmanNode)listIterator.next();
            if (huffmanNode.unmergeable()) continue;
            listIterator.remove();
            while (listIterator.hasNext()) {
                HuffmanNode huffmanNode2 = (HuffmanNode)listIterator.next();
                if (!huffmanNode.mergeInto(huffmanNode2)) continue;
                listIterator.remove();
                while (listIterator.hasNext()) {
                    HuffmanNode huffmanNode3 = (HuffmanNode)listIterator.next();
                    if (!huffmanNode2.tokenEquals(huffmanNode3)) continue;
                    huffmanNode2.mergeInto(huffmanNode3);
                    return;
                }
                listIterator.add(huffmanNode2);
                return;
            }
            huffmanNode.setUnmergeable();
            listIterator.add(huffmanNode);
            listIterator = linkedList.listIterator(0);
        }
    }

    private void expand(LinkedList linkedList, int n) {
        for (HuffmanNode huffmanNode : linkedList) {
            while (huffmanNode.tagLength + n * (huffmanNode.dataLength - huffmanNode.shift) < 6) {
                huffmanNode.incrementLength();
            }
        }
    }

    private void addNodeInOrder(LinkedList linkedList, HuffmanNode huffmanNode, Comparator comparator) {
        ListIterator<HuffmanNode> listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            HuffmanNode huffmanNode2 = (HuffmanNode)listIterator.next();
            if (comparator.compare(huffmanNode2, huffmanNode) <= 0) continue;
            huffmanNode2 = (HuffmanNode)listIterator.previous();
            break;
        }
        listIterator.add(huffmanNode);
    }

    void outputCommands(CommandStream commandStream) {
        LinkedList linkedList = new LinkedList();
        this.getEntries(this.positions, linkedList);
        this.outputCommands(linkedList, commandStream, 0);
        linkedList.clear();
        this.getEntries(this.colors, linkedList);
        this.outputCommands(linkedList, commandStream, 1);
        linkedList.clear();
        this.getEntries(this.normals, linkedList);
        this.outputCommands(linkedList, commandStream, 2);
    }

    private void outputCommands(Collection collection, CommandStream commandStream, int n) {
        for (HuffmanNode huffmanNode : collection) {
            int n2 = 1 << huffmanNode.tagLength | huffmanNode.tag;
            int n3 = huffmanNode.dataLength == 16 ? 0 : huffmanNode.dataLength;
            int n4 = 0x10 | n << 1 | n2 >> 6;
            long l = (n2 & 0x3F) << 9 | n3 << 5 | (huffmanNode.absolute ? 16 : 0) | huffmanNode.shift;
            commandStream.addCommand(n4, 8, l, 15);
        }
    }

    void print(String string, Collection collection) {
        System.out.println(string + "\nentries: " + collection.size() + "\n");
        for (HuffmanNode huffmanNode : collection) {
            System.out.println(huffmanNode.toString() + "\n");
        }
    }

    void print() {
        LinkedList linkedList = new LinkedList();
        this.getEntries(this.positions, linkedList);
        Collections.sort(linkedList, HuffmanNode.frequencyComparator);
        this.print("\nposition tokens and tags", linkedList);
        linkedList.clear();
        this.getEntries(this.colors, linkedList);
        Collections.sort(linkedList, HuffmanNode.frequencyComparator);
        this.print("\ncolor tokens and tags", linkedList);
        linkedList.clear();
        this.getEntries(this.normals, linkedList);
        Collections.sort(linkedList, HuffmanNode.frequencyComparator);
        this.print("\nnormal tokens and tags", linkedList);
    }
}

