/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import megamek.client.ui.swing.util.ImageCache;
import megamek.common.Hex;
import megamek.common.IHex;
import megamek.common.ITerrain;
import megamek.common.Terrains;
import megamek.common.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HexTileset {
    private ArrayList<HexEntry> bases = new ArrayList();
    private ArrayList<HexEntry> supers = new ArrayList();
    private ImageCache<IHex, Image> hexToImageCache = new ImageCache();
    private ImageCache<IHex, List<Image>> hexToImageListCache = new ImageCache();

    public synchronized void clearHex(IHex iHex) {
        this.hexToImageCache.remove(iHex);
    }

    public synchronized Object[] assignMatch(IHex iHex, Component component) {
        IHex iHex2 = iHex.duplicate();
        List<Image> list = this.supersFor(iHex2, component);
        Image image = this.baseFor(iHex2, component);
        Object[] objectArray = new Object[]{image, list};
        this.hexToImageCache.put(iHex, image);
        this.hexToImageListCache.put(iHex, list);
        return objectArray;
    }

    public synchronized Image getBase(IHex iHex, Component component) {
        Image image = this.hexToImageCache.get(iHex);
        if (image == null) {
            Object[] objectArray = this.assignMatch(iHex, component);
            return (Image)objectArray[0];
        }
        return image;
    }

    public synchronized List<Image> getSupers(IHex iHex, Component component) {
        List<Image> list = this.hexToImageListCache.get(iHex);
        if (list == null) {
            Object[] objectArray = this.assignMatch(iHex, component);
            return (List)objectArray[1];
        }
        return list;
    }

    private List<Image> supersFor(IHex iHex, Component component) {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        for (HexEntry hexEntry : this.supers) {
            if (!(this.superMatch(iHex, hexEntry.getHex()) >= 1.0)) continue;
            arrayList.add(hexEntry.getImage(component));
            for (int i = 0; i < Terrains.SIZE; ++i) {
                if (!hexEntry.getHex().containsTerrain(i)) continue;
                iHex.removeTerrain(i);
            }
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    private Image baseFor(IHex iHex, Component component) {
        HexEntry hexEntry = null;
        double d = -1.0;
        for (HexEntry hexEntry2 : this.bases) {
            double d2 = this.baseMatch(iHex, hexEntry2.getHex());
            if (d2 == 1.0) {
                hexEntry = hexEntry2;
                break;
            }
            if (!(d2 > d)) continue;
            hexEntry = hexEntry2;
            d = d2;
        }
        return hexEntry.getImage(component);
    }

    public void loadFromFile(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader("data/images/hexes/" + string));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        streamTokenizer.quoteChar(34);
        streamTokenizer.wordChars(95, 95);
        while (streamTokenizer.nextToken() != -1) {
            int n = 0;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equals("base") && !streamTokenizer.sval.equals("super")) continue;
            boolean bl = streamTokenizer.sval.equals("base");
            n = streamTokenizer.nextToken() == -2 ? (int)streamTokenizer.nval : Integer.MAX_VALUE;
            streamTokenizer.nextToken();
            string2 = streamTokenizer.sval;
            streamTokenizer.nextToken();
            string3 = streamTokenizer.sval;
            streamTokenizer.nextToken();
            string4 = streamTokenizer.sval;
            if (bl) {
                this.bases.add(new HexEntry(new Hex(n, string2, string3), string4));
                continue;
            }
            this.supers.add(new HexEntry(new Hex(n, string2, string3), string4));
        }
        ((Reader)bufferedReader).close();
        System.out.println("hexTileset: loaded " + this.bases.size() + " base images");
        System.out.println("hexTileset: loaded " + this.supers.size() + " super images");
    }

    public void loadAllImages(Component component, MediaTracker mediaTracker) {
        for (HexEntry hexEntry : this.bases) {
            if (hexEntry.getImage() == null) {
                hexEntry.loadImage(component);
            }
            mediaTracker.addImage(hexEntry.getImage(), 1);
        }
        for (HexEntry hexEntry : this.supers) {
            if (hexEntry.getImage() == null) {
                hexEntry.loadImage(component);
            }
            mediaTracker.addImage(hexEntry.getImage(), 1);
        }
    }

    public synchronized void trackHexImages(IHex iHex, MediaTracker mediaTracker) {
        Image image = this.hexToImageCache.get(iHex);
        List<Image> list = this.hexToImageListCache.get(iHex);
        mediaTracker.addImage(image, 1);
        if (list != null) {
            Iterator<Image> iterator = list.iterator();
            while (iterator.hasNext()) {
                mediaTracker.addImage(iterator.next(), 1);
            }
        }
    }

    public void loadHexImage(IHex iHex, Component component, MediaTracker mediaTracker) {
    }

    public synchronized void reset() {
        this.hexToImageCache = new ImageCache();
        this.hexToImageListCache = new ImageCache();
    }

    private double superMatch(IHex iHex, IHex iHex2) {
        if (iHex2.getElevation() != Integer.MAX_VALUE && iHex.getElevation() != iHex2.getElevation()) {
            return 0.0;
        }
        for (int i = 0; i < Terrains.SIZE; ++i) {
            ITerrain iTerrain = iHex2.getTerrain(i);
            ITerrain iTerrain2 = iHex.getTerrain(i);
            if (iTerrain == null || iTerrain2 != null && (iTerrain.getLevel() == Integer.MAX_VALUE || iTerrain2.getLevel() == iTerrain.getLevel()) && (!iTerrain.hasExitsSpecified() || iTerrain2.getExits() == iTerrain.getExits())) continue;
            return 0.0;
        }
        if (iHex2.getTheme() != null && !iHex2.getTheme().equalsIgnoreCase(iHex.getTheme())) {
            return 0.0;
        }
        return 1.0;
    }

    private double baseMatch(IHex iHex, IHex iHex2) {
        double d = iHex2.getElevation() == Integer.MAX_VALUE ? 1.0 : 1.01 / ((double)Math.abs(iHex.getElevation() - iHex2.getElevation()) + 1.01);
        double d2 = Math.max(iHex.terrainsPresent(), iHex2.terrainsPresent());
        double d3 = 0.0;
        for (int i = 0; i < Terrains.SIZE; ++i) {
            ITerrain iTerrain = iHex2.getTerrain(i);
            ITerrain iTerrain2 = iHex.getTerrain(i);
            if (iTerrain == null || iTerrain2 == null) continue;
            double d4 = 0.0;
            d4 = iTerrain.getLevel() == Integer.MAX_VALUE ? 1.0 : 1.0 / ((double)Math.abs(iTerrain2.getLevel() - iTerrain.getLevel()) + 1.0);
            if (iTerrain.hasExitsSpecified() && iTerrain2.getExits() != iTerrain.getExits()) {
                d4 *= 0.5;
            }
            d3 += d4;
        }
        double d5 = d2 == 0.0 ? 1.0 : d3 / d2;
        double d6 = iHex2.getTheme() == iHex.getTheme() || iHex2.getTheme() != null && iHex2.getTheme().equalsIgnoreCase(iHex.getTheme()) ? 1.0 : 1.0E-4;
        return d * d5 * d6;
    }

    private class HexEntry {
        private IHex hex;
        private String imageFile;
        private Image image;
        private Vector<Image> images;
        private Vector<String> filenames;
        private Random r;

        public HexEntry(IHex iHex, String string) {
            this.hex = iHex;
            this.imageFile = string;
            this.r = new Random();
            this.filenames = StringUtil.splitString(string, ";");
        }

        public IHex getHex() {
            return this.hex;
        }

        public Image getImage() {
            return this.image;
        }

        public String getImageFileName() {
            return "data/images/hexes/" + this.imageFile;
        }

        public Image getImage(Component component) {
            if (this.images == null) {
                this.loadImage(component);
            }
            if (this.images.size() > 1) {
                int n = (int)(this.r.nextDouble() * (double)this.images.size());
                return this.images.elementAt(n);
            }
            return this.images.firstElement();
        }

        public void loadImage(Component component) {
            this.images = new Vector();
            for (int i = 0; i < this.filenames.size(); ++i) {
                String string = this.filenames.elementAt(i);
                this.images.addElement(component.getToolkit().getImage("data/images/hexes/" + string));
            }
        }
    }
}

