/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.options;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.options.AbstractOptionsInfo;
import megamek.common.options.IBasicOptionGroup;
import megamek.common.options.IOption;
import megamek.common.options.IOptionGroup;
import megamek.common.options.IOptionInfo;
import megamek.common.options.IOptions;
import megamek.common.options.IOptionsInfo;
import megamek.common.options.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOptions
implements IOptions,
Serializable {
    private static final long serialVersionUID = 6406883135074654379L;
    private Hashtable<String, IOption> optionsHash = new Hashtable();

    protected AbstractOptions() {
        this.initialize();
        this.getOptionsInfoImp().finish();
    }

    protected abstract void initialize();

    @Override
    public Enumeration<IOptionGroup> getGroups() {
        return new GroupsEnumeration();
    }

    @Override
    public Enumeration<IOption> getOptions() {
        return this.optionsHash.elements();
    }

    @Override
    public IOptionInfo getOptionInfo(String string) {
        return this.getOptionsInfo().getOptionInfo(string);
    }

    @Override
    public IOption getOption(String string) {
        return this.optionsHash.get(string);
    }

    @Override
    public boolean booleanOption(String string) {
        return this.getOption(string).booleanValue();
    }

    @Override
    public int intOption(String string) {
        return this.getOption(string).intValue();
    }

    @Override
    public float floatOption(String string) {
        return this.getOption(string).floatValue();
    }

    @Override
    public String stringOption(String string) {
        return this.getOption(string).stringValue();
    }

    IOptionsInfo getOptionsInfo() {
        return this.getOptionsInfoImp();
    }

    protected abstract AbstractOptionsInfo getOptionsInfoImp();

    protected IBasicOptionGroup addGroup(String string) {
        return this.getOptionsInfoImp().addGroup(string);
    }

    protected IBasicOptionGroup addGroup(String string, String string2) {
        return this.getOptionsInfoImp().addGroup(string, string2);
    }

    protected void addOption(IBasicOptionGroup iBasicOptionGroup, String string, String string2) {
        this.addOption(iBasicOptionGroup, string, 3, string2);
    }

    protected void addOption(IBasicOptionGroup iBasicOptionGroup, String string, boolean bl) {
        this.addOption(iBasicOptionGroup, string, 0, new Boolean(bl));
    }

    protected void addOption(IBasicOptionGroup iBasicOptionGroup, String string, int n) {
        this.addOption(iBasicOptionGroup, string, 1, new Integer(n));
    }

    protected void addOption(IBasicOptionGroup iBasicOptionGroup, String string, float f) {
        this.addOption(iBasicOptionGroup, string, 2, new Float(f));
    }

    protected void addOption(IBasicOptionGroup iBasicOptionGroup, String string, Vector<String> vector) {
        this.addOption(iBasicOptionGroup, string, 4, "");
    }

    protected void addOption(IBasicOptionGroup iBasicOptionGroup, String string, int n, Object object) {
        this.optionsHash.put(string, new Option(this, string, n, object));
        this.getOptionsInfoImp().addOptionInfo(iBasicOptionGroup, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GroupsEnumeration
    implements Enumeration<IOptionGroup> {
        private Enumeration<IBasicOptionGroup> groups;

        GroupsEnumeration() {
            this.groups = AbstractOptions.this.getOptionsInfo().getGroups();
        }

        @Override
        public boolean hasMoreElements() {
            return this.groups.hasMoreElements();
        }

        @Override
        public IOptionGroup nextElement() {
            return new GroupProxy(this.groups.nextElement());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class GroupProxy
        implements IOptionGroup {
            private IBasicOptionGroup group;

            GroupProxy(IBasicOptionGroup iBasicOptionGroup) {
                this.group = iBasicOptionGroup;
            }

            @Override
            public String getKey() {
                return this.group.getKey();
            }

            @Override
            public String getName() {
                return this.group.getName();
            }

            @Override
            public String getDisplayableName() {
                return AbstractOptions.this.getOptionsInfoImp().getGroupDisplayableName(this.group.getName());
            }

            @Override
            public Enumeration<String> getOptionNames() {
                return this.group.getOptionNames();
            }

            @Override
            public Enumeration<IOption> getOptions() {
                return new OptionsEnumeration();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected class OptionsEnumeration
            implements Enumeration<IOption> {
                private Enumeration<String> optionNames;

                OptionsEnumeration() {
                    this.optionNames = GroupProxy.this.group.getOptionNames();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.optionNames.hasMoreElements();
                }

                @Override
                public IOption nextElement() {
                    return AbstractOptions.this.getOption(this.optionNames.nextElement());
                }
            }
        }
    }
}

