/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.AclRule;
import com.dtolabs.rundeck.core.authorization.AclRuleSet;
import com.dtolabs.rundeck.core.authorization.AclRuleSetImpl;
import com.dtolabs.rundeck.core.authorization.ValidationSet;
import com.dtolabs.rundeck.core.authorization.providers.AclPolicySyntaxException;
import com.dtolabs.rundeck.core.authorization.providers.Policy;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class YamlPolicyCollection
implements PolicyCollection {
    private final List<Policy> all = new ArrayList<Policy>();
    private final Set<AclRule> ruleSet = new HashSet<AclRule>();
    String identity;
    final ValidationSet validation;

    public YamlPolicyCollection(String identity, YamlSourceLoader loader, YamlPolicyCreator creator, ValidationSet validation) throws IOException {
        this.identity = identity;
        this.validation = validation;
        this.load(loader, creator);
    }

    @Override
    public AclRuleSet getRuleSet() {
        return new AclRuleSetImpl(this.ruleSet);
    }

    private <T> void load(YamlSourceLoader<T> loader, YamlPolicyCreator<T> creator) throws IOException {
        int index = 1;
        try (YamlSourceLoader<T> loader1 = loader;){
            for (T yamlDoc : loader1.loadAll()) {
                String ident = this.identity + "[" + index + "]";
                if (null == yamlDoc) continue;
                try {
                    Policy yamlPolicy = creator.createYamlPolicy(yamlDoc, this.identity + "[" + index + "]", index);
                    this.all.add(yamlPolicy);
                    this.ruleSet.addAll(yamlPolicy.getRuleSet().getRules());
                }
                catch (AclPolicySyntaxException e) {
                    this.validationError(ident, e.getMessage());
                }
                ++index;
            }
        }
    }

    private void validationError(String ident, String reason) {
        if (null != this.validation) {
            this.validation.addError(ident, reason);
        }
    }

    @Override
    public Collection<String> groupNames() {
        ArrayList<String> groups2 = new ArrayList<String>();
        for (Policy policy : this.all) {
            for (String policyGroup : policy.getGroups()) {
                groups2.add(policyGroup);
            }
        }
        return groups2;
    }

    @Override
    public long countPolicies() {
        return this.all.size();
    }

    public List<Policy> getPolicies() {
        return this.all;
    }

    static interface YamlPolicyCreator<T> {
        public Policy createYamlPolicy(T var1, String var2, int var3) throws AclPolicySyntaxException;
    }

    static interface YamlSourceLoader<T>
    extends Closeable {
        public Iterable<T> loadAll() throws IOException;
    }
}

