/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.util;

import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

public abstract class SafeWorker<T, V>
extends SwingWorker<T, V> {
    @Override
    protected final void done() {
        try {
            if (this.isCancelled()) {
                this.cancelled();
            } else {
                try {
                    this.succeeded(this.get());
                }
                catch (InterruptedException e) {
                    this.interrupted(e);
                }
                catch (ExecutionException e) {
                    this.failed(e.getCause());
                }
            }
        }
        finally {
            this.finished();
        }
    }

    protected void succeeded(T result) {
    }

    protected void cancelled() {
    }

    protected void failed(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Background execution failed", throwable);
    }

    protected void interrupted(InterruptedException ex) {
    }

    protected void finished() {
    }
}

