/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.encryption.ARCFour;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PDCryptFilterDictionary;
import org.apache.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;

public class StandardSecurityHandler
extends SecurityHandler {
    public static final String FILTER = "Standard";
    private static final int DEFAULT_VERSION = 1;
    private static final int DEFAULT_REVISION = 3;
    private int revision = 3;
    private StandardProtectionPolicy policy;
    private ARCFour rc4 = new ARCFour();
    public static final Class<?> PROTECTION_POLICY_CLASS = StandardProtectionPolicy.class;
    public static final byte[] ENCRYPT_PADDING = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};

    public StandardSecurityHandler() {
    }

    public StandardSecurityHandler(StandardProtectionPolicy p) {
        this.policy = p;
        this.keyLength = this.policy.getEncryptionKeyLength();
    }

    private int computeVersionNumber() {
        if (this.keyLength == 40) {
            return 1;
        }
        return 2;
    }

    private int computeRevisionNumber() {
        if (this.version < 2 && !this.policy.getPermissions().hasAnyRevision3PermissionSet()) {
            return 2;
        }
        if (this.version == 2 || this.version == 3 || this.policy.getPermissions().hasAnyRevision3PermissionSet()) {
            return 3;
        }
        return 4;
    }

    public void decryptDocument(PDDocument doc, DecryptionMaterial decryptionMaterial) throws CryptographyException, IOException {
        this.document = doc;
        PDEncryptionDictionary dictionary = this.document.getEncryptionDictionary();
        COSArray documentIDArray = this.document.getDocument().getDocumentID();
        this.prepareForDecryption(dictionary, documentIDArray, decryptionMaterial);
        this.proceedDecryption();
    }

    public void prepareForDecryption(PDEncryptionDictionary encDictionary, COSArray documentIDArray, DecryptionMaterial decryptionMaterial) throws CryptographyException, IOException {
        COSName cryptFilterMethod;
        PDCryptFilterDictionary stdCryptFilterDictionary;
        if (!(decryptionMaterial instanceof StandardDecryptionMaterial)) {
            throw new CryptographyException("Provided decryption material is not compatible with the document");
        }
        this.decryptMetadata = encDictionary.isEncryptMetaData();
        StandardDecryptionMaterial material = (StandardDecryptionMaterial)decryptionMaterial;
        String password = material.getPassword();
        if (password == null) {
            password = "";
        }
        int dicPermissions = encDictionary.getPermissions();
        int dicRevision = encDictionary.getRevision();
        int dicLength = encDictionary.getLength() / 8;
        byte[] documentIDBytes = null;
        if (documentIDArray != null && documentIDArray.size() >= 1) {
            COSString id = (COSString)documentIDArray.getObject(0);
            documentIDBytes = id.getBytes();
        } else {
            documentIDBytes = new byte[]{};
        }
        boolean encryptMetadata = encDictionary.isEncryptMetaData();
        byte[] u = encDictionary.getUserKey();
        byte[] o = encDictionary.getOwnerKey();
        boolean isUserPassword = this.isUserPassword(password.getBytes("ISO-8859-1"), u, o, dicPermissions, documentIDBytes, dicRevision, dicLength, encryptMetadata);
        boolean isOwnerPassword = this.isOwnerPassword(password.getBytes("ISO-8859-1"), u, o, dicPermissions, documentIDBytes, dicRevision, dicLength, encryptMetadata);
        if (isUserPassword) {
            this.currentAccessPermission = new AccessPermission(dicPermissions);
            this.currentAccessPermission.setReadOnly();
            this.encryptionKey = this.computeEncryptedKey(password.getBytes("ISO-8859-1"), o, dicPermissions, documentIDBytes, dicRevision, dicLength, encryptMetadata);
        } else if (isOwnerPassword) {
            this.currentAccessPermission = AccessPermission.getOwnerAccessPermission();
            byte[] computedUserPassword = this.getUserPassword(password.getBytes("ISO-8859-1"), o, dicRevision, dicLength);
            this.encryptionKey = this.computeEncryptedKey(computedUserPassword, o, dicPermissions, documentIDBytes, dicRevision, dicLength, encryptMetadata);
        } else {
            throw new CryptographyException("Error: The supplied password does not match either the owner or user password in the document.");
        }
        if ((encDictionary.getVersion() == 4 || encDictionary.getVersion() == 5) && (stdCryptFilterDictionary = encDictionary.getStdCryptFilterDictionary()) != null && (cryptFilterMethod = stdCryptFilterDictionary.getCryptFilterMethod()) != null) {
            this.setAES("AESV2".equalsIgnoreCase(cryptFilterMethod.getName()));
        }
    }

    public void prepareDocumentForEncryption(PDDocument doc) throws CryptographyException, IOException {
        this.document = doc;
        PDEncryptionDictionary encryptionDictionary = this.document.getEncryptionDictionary();
        if (encryptionDictionary == null) {
            encryptionDictionary = new PDEncryptionDictionary();
        }
        this.version = this.computeVersionNumber();
        this.revision = this.computeRevisionNumber();
        encryptionDictionary.setFilter(FILTER);
        encryptionDictionary.setVersion(this.version);
        if (this.version != 4 && this.version != 5) {
            encryptionDictionary.removeV45filters();
        }
        encryptionDictionary.setRevision(this.revision);
        encryptionDictionary.setLength(this.keyLength);
        String ownerPassword = this.policy.getOwnerPassword();
        String userPassword = this.policy.getUserPassword();
        if (ownerPassword == null) {
            ownerPassword = "";
        }
        if (userPassword == null) {
            userPassword = "";
        }
        if (ownerPassword.length() == 0) {
            ownerPassword = userPassword;
        }
        int permissionInt = this.policy.getPermissions().getPermissionBytes();
        encryptionDictionary.setPermissions(permissionInt);
        int length = this.keyLength / 8;
        COSArray idArray = this.document.getDocument().getDocumentID();
        if (idArray == null || idArray.size() < 2) {
            idArray = new COSArray();
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                BigInteger time = BigInteger.valueOf(System.currentTimeMillis());
                md.update(time.toByteArray());
                md.update(ownerPassword.getBytes("ISO-8859-1"));
                md.update(userPassword.getBytes("ISO-8859-1"));
                md.update(this.document.getDocument().toString().getBytes("ISO-8859-1"));
                byte[] id = md.digest(this.toString().getBytes("ISO-8859-1"));
                COSString idString = new COSString();
                idString.append(id);
                idArray.add(idString);
                idArray.add(idString);
                this.document.getDocument().setDocumentID(idArray);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptographyException(e);
            }
            catch (IOException e) {
                throw new CryptographyException(e);
            }
        }
        COSString id = (COSString)idArray.getObject(0);
        byte[] o = this.computeOwnerPassword(ownerPassword.getBytes("ISO-8859-1"), userPassword.getBytes("ISO-8859-1"), this.revision, length);
        byte[] u = this.computeUserPassword(userPassword.getBytes("ISO-8859-1"), o, permissionInt, id.getBytes(), this.revision, length, true);
        this.encryptionKey = this.computeEncryptedKey(userPassword.getBytes("ISO-8859-1"), o, permissionInt, id.getBytes(), this.revision, length, true);
        encryptionDictionary.setOwnerKey(o);
        encryptionDictionary.setUserKey(u);
        this.document.setEncryptionDictionary(encryptionDictionary);
        this.document.getDocument().setEncryptionDictionary(encryptionDictionary.getCOSDictionary());
    }

    public final boolean isOwnerPassword(byte[] ownerPassword, byte[] u, byte[] o, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws CryptographyException, IOException {
        byte[] userPassword = this.getUserPassword(ownerPassword, o, encRevision, length);
        return this.isUserPassword(userPassword, u, o, permissions, id, encRevision, length, encryptMetadata);
    }

    public final byte[] getUserPassword(byte[] ownerPassword, byte[] o, int encRevision, int length) throws CryptographyException, IOException {
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] rc4Key = this.computeRC4key(ownerPassword, encRevision, length);
            if (encRevision == 2 && length != 5) {
                throw new CryptographyException("Error: Expected length=5 actual=" + length);
            }
            if (encRevision == 2) {
                this.rc4.setKey(rc4Key);
                this.rc4.write(o, (OutputStream)result);
            } else if (encRevision == 3 || encRevision == 4) {
                byte[] iterationKey = new byte[rc4Key.length];
                byte[] otemp = new byte[o.length];
                System.arraycopy(o, 0, otemp, 0, o.length);
                this.rc4.write(o, (OutputStream)result);
                for (int i = 19; i >= 0; --i) {
                    System.arraycopy(rc4Key, 0, iterationKey, 0, rc4Key.length);
                    for (int j = 0; j < iterationKey.length; ++j) {
                        iterationKey[j] = (byte)(iterationKey[j] ^ (byte)i);
                    }
                    this.rc4.setKey(iterationKey);
                    result.reset();
                    this.rc4.write(otemp, (OutputStream)result);
                    otemp = result.toByteArray();
                }
            }
            return result.toByteArray();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
    }

    public final byte[] computeEncryptedKey(byte[] password, byte[] o, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws CryptographyException {
        byte[] result = new byte[length];
        try {
            byte[] padded = this.truncateOrPad(password);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(padded);
            md.update(o);
            byte zero = (byte)(permissions >>> 0);
            byte one = (byte)(permissions >>> 8);
            byte two = (byte)(permissions >>> 16);
            byte three = (byte)(permissions >>> 24);
            md.update(zero);
            md.update(one);
            md.update(two);
            md.update(three);
            md.update(id);
            if (encRevision == 4 && !encryptMetadata) {
                md.update(new byte[]{-1, -1, -1, -1});
            }
            byte[] digest = md.digest();
            if (encRevision == 3 || encRevision == 4) {
                for (int i = 0; i < 50; ++i) {
                    md.reset();
                    md.update(digest, 0, length);
                    digest = md.digest();
                }
            }
            if (encRevision == 2 && length != 5) {
                throw new CryptographyException("Error: length should be 5 when revision is two actual=" + length);
            }
            System.arraycopy(digest, 0, result, 0, length);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
        return result;
    }

    public final byte[] computeUserPassword(byte[] password, byte[] o, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws CryptographyException, IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] encryptionKey = this.computeEncryptedKey(password, o, permissions, id, encRevision, length, encryptMetadata);
        if (encRevision == 2) {
            this.rc4.setKey(encryptionKey);
            this.rc4.write(ENCRYPT_PADDING, (OutputStream)result);
        } else if (encRevision == 3 || encRevision == 4) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(ENCRYPT_PADDING);
                md.update(id);
                result.write(md.digest());
                byte[] iterationKey = new byte[encryptionKey.length];
                for (int i = 0; i < 20; ++i) {
                    System.arraycopy(encryptionKey, 0, iterationKey, 0, iterationKey.length);
                    for (int j = 0; j < iterationKey.length; ++j) {
                        iterationKey[j] = (byte)(iterationKey[j] ^ i);
                    }
                    this.rc4.setKey(iterationKey);
                    ByteArrayInputStream input = new ByteArrayInputStream(result.toByteArray());
                    result.reset();
                    this.rc4.write(input, (OutputStream)result);
                }
                byte[] finalResult = new byte[32];
                System.arraycopy(result.toByteArray(), 0, finalResult, 0, 16);
                System.arraycopy(ENCRYPT_PADDING, 0, finalResult, 16, 16);
                result.reset();
                result.write(finalResult);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptographyException(e);
            }
        }
        return result.toByteArray();
    }

    public final byte[] computeOwnerPassword(byte[] ownerPassword, byte[] userPassword, int encRevision, int length) throws CryptographyException, IOException {
        try {
            byte[] rc4Key = this.computeRC4key(ownerPassword, encRevision, length);
            byte[] paddedUser = this.truncateOrPad(userPassword);
            this.rc4.setKey(rc4Key);
            ByteArrayOutputStream crypted = new ByteArrayOutputStream();
            this.rc4.write(new ByteArrayInputStream(paddedUser), (OutputStream)crypted);
            if (encRevision == 3 || encRevision == 4) {
                byte[] iterationKey = new byte[rc4Key.length];
                for (int i = 1; i < 20; ++i) {
                    System.arraycopy(rc4Key, 0, iterationKey, 0, rc4Key.length);
                    for (int j = 0; j < iterationKey.length; ++j) {
                        iterationKey[j] = (byte)(iterationKey[j] ^ (byte)i);
                    }
                    this.rc4.setKey(iterationKey);
                    ByteArrayInputStream input = new ByteArrayInputStream(crypted.toByteArray());
                    crypted.reset();
                    this.rc4.write(input, (OutputStream)crypted);
                }
            }
            return crypted.toByteArray();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e.getMessage());
        }
    }

    private byte[] computeRC4key(byte[] ownerPassword, int encRevision, int length) throws NoSuchAlgorithmException, CryptographyException {
        if (encRevision == 2 && length != 5) {
            throw new CryptographyException("Error: Expected length=5 actual=" + length);
        }
        byte[] ownerPadded = this.truncateOrPad(ownerPassword);
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(ownerPadded);
        byte[] digest = md.digest();
        if (encRevision == 3 || encRevision == 4) {
            for (int i = 0; i < 50; ++i) {
                md.reset();
                md.update(digest, 0, length);
                digest = md.digest();
            }
        }
        byte[] rc4Key = new byte[length];
        System.arraycopy(digest, 0, rc4Key, 0, length);
        return rc4Key;
    }

    private final byte[] truncateOrPad(byte[] password) {
        byte[] padded = new byte[ENCRYPT_PADDING.length];
        int bytesBeforePad = Math.min(password.length, padded.length);
        System.arraycopy(password, 0, padded, 0, bytesBeforePad);
        System.arraycopy(ENCRYPT_PADDING, 0, padded, bytesBeforePad, ENCRYPT_PADDING.length - bytesBeforePad);
        return padded;
    }

    public final boolean isUserPassword(byte[] password, byte[] u, byte[] o, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws CryptographyException, IOException {
        boolean matches = false;
        byte[] computedValue = this.computeUserPassword(password, o, permissions, id, encRevision, length, encryptMetadata);
        if (encRevision == 2) {
            matches = Arrays.equals(u, computedValue);
        } else if (encRevision == 3 || encRevision == 4) {
            matches = StandardSecurityHandler.arraysEqual(u, computedValue, 16);
        } else {
            throw new IOException("Unknown Encryption Revision " + encRevision);
        }
        return matches;
    }

    public final boolean isUserPassword(String password, byte[] u, byte[] o, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws CryptographyException, IOException {
        return this.isUserPassword(password.getBytes("ISO-8859-1"), u, o, permissions, id, encRevision, length, encryptMetadata);
    }

    public final boolean isOwnerPassword(String password, byte[] u, byte[] o, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws CryptographyException, IOException {
        return this.isOwnerPassword(password.getBytes("ISO-8859-1"), u, o, permissions, id, encRevision, length, encryptMetadata);
    }

    private static final boolean arraysEqual(byte[] first, byte[] second, int count) {
        if (first.length < count || second.length < count) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (first[i] == second[i]) continue;
            return false;
        }
        return true;
    }

    public boolean hasProtectionPolicy() {
        return this.policy != null;
    }
}

