/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.template;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class AddLevelToken
extends AbstractNonEmptyToken<PCTemplate>
implements CDOMPrimaryToken<PCTemplate> {
    public String getTokenName() {
        return "ADDLEVEL";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, PCTemplate template, String value) {
        Formula f;
        ParsingSeparator sep = new ParsingSeparator(value, '|');
        String classString = sep.next();
        if (classString.length() == 0) {
            ComplexParseResult cpr = new ComplexParseResult();
            cpr.addErrorMessage("Empty Class found in " + this.getTokenName());
            cpr.addErrorMessage("  " + this.getTokenName() + " requires at format: Class|LevelCount");
            return cpr;
        }
        if (!sep.hasNext()) {
            ComplexParseResult cpr = new ComplexParseResult();
            cpr.addErrorMessage("No | found in " + this.getTokenName());
            cpr.addErrorMessage("  " + this.getTokenName() + " requires at format: Class|LevelCount");
            return cpr;
        }
        String numLevels = sep.next();
        if (numLevels.length() == 0) {
            ComplexParseResult cpr = new ComplexParseResult();
            cpr.addErrorMessage("Empty Level Count found in " + this.getTokenName());
            cpr.addErrorMessage("  " + this.getTokenName() + " requires at format: Class|LevelCount");
            return cpr;
        }
        if (sep.hasNext()) {
            ComplexParseResult cpr = new ComplexParseResult();
            cpr.addErrorMessage("Two | found in " + this.getTokenName());
            cpr.addErrorMessage("  " + this.getTokenName() + " requires at format: Class|LevelCount");
            return cpr;
        }
        CDOMSingleRef cl = context.getReferenceContext().getCDOMReference(PCClass.class, classString);
        try {
            int lvls = Integer.parseInt(numLevels);
            if (lvls <= 0) {
                return new ParseResult.Fail("Number of Levels granted in " + this.getTokenName() + " must be greater than zero", context);
            }
            f = FormulaFactory.getFormulaFor((Integer)lvls);
        }
        catch (NumberFormatException nfe) {
            f = FormulaFactory.getFormulaFor((String)numLevels);
        }
        if (!f.isValid()) {
            return new ParseResult.Fail("Formula in " + this.getTokenName() + " was not valid: " + f.toString(), context);
        }
        LevelCommandFactory cf = new LevelCommandFactory(cl, f);
        context.getObjectContext().addToList((CDOMObject)template, ListKey.ADD_LEVEL, (Object)cf);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCTemplate pct) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)pct, ListKey.ADD_LEVEL);
        Collection added = changes.getAdded();
        if (added == null || added.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (LevelCommandFactory lcf : added) {
            StringBuilder sb = new StringBuilder();
            sb.append(lcf.getLSTformat()).append("|").append(lcf.getLevelCount().toString());
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }
}

