/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class KunststoffListUI
extends BasicListUI {
    private boolean isToolkitTrueColor = false;

    public KunststoffListUI(JComponent jComponent) {
        this.isToolkitTrueColor = KunststoffUtilities.isToolkitTrueColor(jComponent);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new KunststoffListUI(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = jComponent.getBackground();
            int n = KunststoffLookAndFeel.getBackgroundGradientShadow();
            if (color != null) {
                Rectangle rectangle = graphics.getClipBounds();
                if (n == 0) {
                    graphics2D.setColor(color);
                    graphics2D.fill(rectangle);
                } else {
                    int n2 = color.getRed();
                    int n3 = color.getGreen();
                    int n4 = color.getBlue();
                    Color color2 = new Color(n2 >= n ? n2 - n : 0, n3 >= n ? n3 - n : 0, n4 >= n ? n4 - n : 0);
                    if (this.isToolkitTrueColor) {
                        Rectangle rectangle2 = new Rectangle(0, 0, this.list.getWidth(), this.list.getHeight());
                        KunststoffUtilities.drawGradient(graphics, color, color2, rectangle2, rectangle, false);
                    } else {
                        graphics2D.setColor(color);
                        graphics2D.fill(rectangle);
                        Color color3 = KunststoffUtilities.getTranslucentColor(color2, 0);
                        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color2, 0.0f, 5.0f, color3);
                        graphics2D.setPaint(gradientPaint);
                        graphics2D.fill(new Rectangle(rectangle.x, rectangle.y, rectangle.width, 20));
                        GradientPaint gradientPaint2 = new GradientPaint(0.0f, 0.0f, color2, 5.0f, 0.0f, color3);
                        graphics2D.setPaint(gradientPaint2);
                        graphics2D.fill(new Rectangle(rectangle.x, rectangle.y, 20, rectangle.height));
                    }
                }
            }
        }
        this.paint(graphics, jComponent);
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        JComponent jComponent;
        if (listCellRenderer instanceof JComponent && !listSelectionModel.isSelectedIndex(n) && (jComponent = (JComponent)((Object)listCellRenderer)).getBackground() instanceof ColorUIResource && jComponent.isOpaque()) {
            jComponent.setOpaque(false);
            super.paintCell(graphics, n, rectangle, listCellRenderer, listModel, listSelectionModel, n2);
            jComponent.setOpaque(true);
            return;
        }
        super.paintCell(graphics, n, rectangle, listCellRenderer, listModel, listSelectionModel, n2);
    }
}

