/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ConcretePersistentTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SkillToken
extends AbstractToken
implements CDOMSecondaryToken<CDOMObject>,
PersistentChoiceActor<Skill> {
    private static final Class<Skill> SKILL_CLASS = Skill.class;

    public String getTokenName() {
        return "SKILL";
    }

    public String getParentToken() {
        return "ADD";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public ParseResult parseToken(LoadContext context, CDOMObject obj, String value) {
        Formula count;
        if (this.isEmpty(value)) {
            return new ParseResult.Fail("Value in " + this.getFullName() + " may not be empty", context);
        }
        ParsingSeparator sep = new ParsingSeparator(value, '|');
        String activeValue = sep.next();
        if (!sep.hasNext()) {
            count = FormulaFactory.ONE;
        } else {
            count = FormulaFactory.getFormulaFor((String)activeValue);
            if (!count.isValid()) {
                return new ParseResult.Fail("Count in " + this.getTokenName() + " was not valid: " + count.toString(), context);
            }
            if (count.isStatic() && count.resolveStatic().doubleValue() <= 0.0) {
                return new ParseResult.Fail("Count in " + this.getFullName() + " must be > 0", context);
            }
            activeValue = sep.next();
        }
        if (sep.hasNext()) {
            return new ParseResult.Fail(this.getFullName() + " had too many pipe separated items: " + value, context);
        }
        ParseResult pr = this.checkSeparatorsAndNonEmpty(',', activeValue);
        if (!pr.passed()) {
            return pr;
        }
        StringTokenizer tok = new StringTokenizer(activeValue, ",");
        ArrayList<CDOMGroupRef> refs = new ArrayList<CDOMGroupRef>();
        while (tok.hasMoreTokens()) {
            CDOMGroupRef ref;
            String token = tok.nextToken();
            if ("ANY".equalsIgnoreCase(token)) {
                ref = context.getReferenceContext().getCDOMAllReference(SKILL_CLASS);
            } else {
                ref = TokenUtilities.getTypeOrPrimitive((LoadContext)context, SKILL_CLASS, (String)token);
                if (ref == null) {
                    return new ParseResult.Fail("  Error was encountered while parsing " + this.getFullName() + ": " + token + " is not a valid reference: " + value, context);
                }
            }
            refs.add(ref);
        }
        ReferenceChoiceSet rcs = new ReferenceChoiceSet(refs);
        if (!rcs.getGroupingState().isValid()) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + value, context);
        }
        ChoiceSet cs = new ChoiceSet("SKILL", (PrimitiveChoiceSet)rcs, true);
        ConcretePersistentTransitionChoice tc = new ConcretePersistentTransitionChoice((SelectableSet)cs, count);
        context.getObjectContext().addToList(obj, ListKey.ADD, (Object)tc);
        tc.setChoiceActor((ChoiceActor)this);
        tc.allowStack(true);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes grantChanges = context.getObjectContext().getListChanges(obj, ListKey.ADD);
        Collection addedItems = grantChanges.getAdded();
        if (addedItems == null || addedItems.isEmpty()) {
            return null;
        }
        ArrayList<String> addStrings = new ArrayList<String>();
        for (TransitionChoice container : addedItems) {
            SelectableSet cs = container.getChoices();
            if (!this.getTokenName().equals(cs.getName()) || !SKILL_CLASS.equals(cs.getChoiceClass())) continue;
            Formula f = container.getCount();
            if (f == null) {
                context.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            if (f.isStatic() && f.resolveStatic().doubleValue() <= 0.0) {
                context.addWriteMessage("Count in " + this.getFullName() + " must be > 0");
                return null;
            }
            if (!cs.getGroupingState().isValid()) {
                context.addWriteMessage("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + cs.getLSTformat());
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (!FormulaFactory.ONE.equals(f)) {
                sb.append(f).append("|");
            }
            sb.append(cs.getLSTformat());
            addStrings.add(sb.toString());
        }
        return addStrings.toArray(new String[addStrings.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(CDOMObject owner, Skill choice, PlayerCharacter pc) {
        SkillRankControl.modRanks((double)1.0, null, (boolean)true, (PlayerCharacter)pc, (Skill)choice);
    }

    public boolean allow(Skill choice, PlayerCharacter pc, boolean allowStack) {
        return true;
    }

    public Skill decodeChoice(LoadContext context, String s) {
        return (Skill)context.getReferenceContext().silentlyGetConstructedCDOMObject(SKILL_CLASS, s);
    }

    public String encodeChoice(Skill choice) {
        return choice.getKeyName();
    }

    public void restoreChoice(PlayerCharacter pc, CDOMObject owner, Skill choice) {
    }

    public void removeChoice(PlayerCharacter pc, CDOMObject owner, Skill choice) {
        SkillRankControl.modRanks((double)-1.0, null, (boolean)true, (PlayerCharacter)pc, (Skill)choice);
    }
}

