/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ConcretePersistentTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.ClassSkillChoiceActor;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.ObjectMatchingReference;
import pcgen.core.PCClass;
import pcgen.core.Skill;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class ClassSkillsLevelToken
extends AbstractNonEmptyToken<PCClassLevel>
implements CDOMSecondaryToken<PCClassLevel> {
    private static final Class<Skill> SKILL_CLASS = Skill.class;

    public String getTokenName() {
        return "CLASSSKILLS";
    }

    public String getParentToken() {
        return "ADD";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, PCClassLevel obj, String value) {
        Formula count;
        ParsingSeparator sep = new ParsingSeparator(value, '|');
        String activeValue = sep.next();
        if (!sep.hasNext()) {
            count = FormulaFactory.ONE;
        } else {
            count = FormulaFactory.getFormulaFor((String)activeValue);
            if (!count.isValid()) {
                return new ParseResult.Fail("Count in " + this.getTokenName() + " was not valid: " + count.toString(), context);
            }
            if (count.isStatic() && count.resolveStatic().doubleValue() <= 0.0) {
                return new ParseResult.Fail("Count in " + this.getFullName() + " must be > 0", context);
            }
            activeValue = sep.next();
        }
        if (sep.hasNext()) {
            return new ParseResult.Fail(this.getFullName() + " had too many pipe separated items: " + value, context);
        }
        ParseResult pr = this.checkSeparatorsAndNonEmpty(',', activeValue);
        if (!pr.passed()) {
            return pr;
        }
        ArrayList<Object> refs = new ArrayList<Object>();
        StringTokenizer tok = new StringTokenizer(activeValue, ",");
        CDOMGroupRef allRef = context.getReferenceContext().getCDOMAllReference(SKILL_CLASS);
        Integer autoRank = null;
        while (tok.hasMoreTokens()) {
            ObjectMatchingReference omr;
            String tokText = tok.nextToken();
            if ("ALL".equals(tokText) || "ANY".equals(tokText)) {
                refs.add(allRef);
                continue;
            }
            if ("UNTRAINED".equals(tokText)) {
                omr = new ObjectMatchingReference(tokText, SKILL_CLASS, allRef, ObjectKey.USE_UNTRAINED, (Object)Boolean.TRUE);
                omr.returnIncludesNulls(true);
                refs.add(omr);
                continue;
            }
            if ("TRAINED".equals(tokText)) {
                refs.add(new ObjectMatchingReference(tokText, SKILL_CLASS, allRef, ObjectKey.USE_UNTRAINED, (Object)Boolean.FALSE));
                continue;
            }
            if ("EXCLUSIVE".equals(tokText)) {
                refs.add(new ObjectMatchingReference(tokText, SKILL_CLASS, allRef, ObjectKey.EXCLUSIVE, (Object)Boolean.TRUE));
                continue;
            }
            if ("NONEXCLUSIVE".equals(tokText) || "CROSSCLASSSKILLS".equals(tokText)) {
                omr = new ObjectMatchingReference(tokText, SKILL_CLASS, allRef, ObjectKey.EXCLUSIVE, (Object)Boolean.FALSE);
                omr.returnIncludesNulls(true);
                refs.add(omr);
                continue;
            }
            if (tokText.startsWith("AUTORANK=")) {
                if (autoRank != null) {
                    return new ParseResult.Fail("Cannot have two AUTORANK= items in " + this.getFullName() + ": " + value, context);
                }
                String rankString = tokText.substring(9);
                try {
                    autoRank = Integer.decode(rankString);
                    if (autoRank > 0) continue;
                    return new ParseResult.Fail("Expected AUTORANK= to be greater than zero, found: " + autoRank, context);
                }
                catch (NumberFormatException e) {
                    return new ParseResult.Fail("Expected AUTORANK= to have an integer value, found: " + rankString, context);
                }
            }
            CDOMReference skref = TokenUtilities.getTypeOrPrimitive((LoadContext)context, SKILL_CLASS, (String)tokText);
            if (skref == null) {
                return new ParseResult.Fail("  Error was encountered while parsing " + this.getFullName() + ": " + value + " had an invalid reference: " + tokText, context);
            }
            refs.add(skref);
        }
        if (refs.isEmpty()) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains no skill reference: " + value, context);
        }
        ReferenceChoiceSet rcs = new ReferenceChoiceSet(refs);
        if (!rcs.getGroupingState().isValid()) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + value, context);
        }
        ChoiceSet cs = new ChoiceSet(this.getTokenName(), (PrimitiveChoiceSet)rcs, true);
        ConcretePersistentTransitionChoice tc = new ConcretePersistentTransitionChoice((SelectableSet)cs, count);
        PCClass parent = (PCClass)obj.get(ObjectKey.TOKEN_PARENT);
        ClassSkillChoiceActor actor = new ClassSkillChoiceActor(parent, autoRank);
        tc.setChoiceActor((ChoiceActor)actor);
        context.getObjectContext().addToList((CDOMObject)obj, ListKey.ADD, (Object)tc);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCClassLevel obj) {
        Changes grantChanges = context.getObjectContext().getListChanges((CDOMObject)obj, ListKey.ADD);
        Collection addedItems = grantChanges.getAdded();
        if (addedItems == null || addedItems.isEmpty()) {
            return null;
        }
        ArrayList<String> addStrings = new ArrayList<String>();
        for (TransitionChoice container : addedItems) {
            SelectableSet cs = container.getChoices();
            if (!this.getTokenName().equals(cs.getName()) || !SKILL_CLASS.equals(cs.getChoiceClass())) continue;
            Formula f = container.getCount();
            if (f == null) {
                context.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            if (f.isStatic() && f.resolveStatic().doubleValue() <= 0.0) {
                context.addWriteMessage("Count in " + this.getFullName() + " must be > 0");
                return null;
            }
            if (!cs.getGroupingState().isValid()) {
                context.addWriteMessage("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + cs.getLSTformat());
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (!FormulaFactory.ONE.equals(f)) {
                sb.append(f).append("|");
            }
            sb.append(cs.getLSTformat());
            ClassSkillChoiceActor actor = (ClassSkillChoiceActor)container.getChoiceActor();
            Integer rank = actor.getApplyRank();
            if (rank != null) {
                sb.append(",").append("AUTORANK=" + rank);
            }
            addStrings.add(sb.toString());
        }
        return addStrings.toArray(new String[addStrings.size()]);
    }

    public Class<PCClassLevel> getTokenClass() {
        return PCClassLevel.class;
    }
}

