/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.skill;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Skill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.Visibility;

public class VisibleToken
extends AbstractNonEmptyToken<Skill>
implements CDOMPrimaryToken<Skill> {
    public String getTokenName() {
        return "VISIBLE";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, Skill skill, String value) {
        Visibility vis;
        String visString = value;
        int pipeLoc = value.indexOf("|");
        boolean readOnly = false;
        if (pipeLoc != -1) {
            if (value.substring(pipeLoc + 1).equals("READONLY")) {
                visString = value.substring(0, pipeLoc);
                readOnly = true;
            } else {
                return new ParseResult.Fail("Misunderstood text after pipe on Tag: " + value, context);
            }
        }
        if (visString.equals("YES")) {
            vis = Visibility.DEFAULT;
        } else if (visString.equals("ALWAYS")) {
            vis = Visibility.DEFAULT;
        } else if (visString.equals("DISPLAY")) {
            vis = Visibility.DISPLAY_ONLY;
        } else if (visString.equals("GUI")) {
            vis = Visibility.DISPLAY_ONLY;
        } else if (visString.equals("EXPORT")) {
            vis = Visibility.OUTPUT_ONLY;
        } else if (visString.equals("CSHEET")) {
            vis = Visibility.OUTPUT_ONLY;
        } else if (visString.equals("NO")) {
            vis = Visibility.HIDDEN;
        } else {
            ComplexParseResult cpr = new ComplexParseResult();
            cpr.addErrorMessage("Unexpected value used in " + this.getTokenName() + " in Skill");
            cpr.addErrorMessage(" " + value + " is not a valid value for " + this.getTokenName());
            cpr.addErrorMessage(" Valid values in Skill are YES, ALWAYS, NO, DISPLAY, GUI, EXPORT, CSHEET");
            return cpr;
        }
        context.getObjectContext().put((CDOMObject)skill, ObjectKey.VISIBILITY, (Object)vis);
        if (readOnly) {
            if (vis.equals((Object)Visibility.OUTPUT_ONLY)) {
                return new ParseResult.Fail("|READONLY suffix not valid with " + this.getTokenName() + " EXPORT or CSHEET", context);
            }
            context.getObjectContext().put((CDOMObject)skill, ObjectKey.READ_ONLY, (Object)Boolean.TRUE);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Skill skill) {
        Visibility vis = (Visibility)context.getObjectContext().getObject((CDOMObject)skill, ObjectKey.VISIBILITY);
        if (vis == null) {
            return null;
        }
        if (!(vis.equals((Object)Visibility.DEFAULT) || vis.equals((Object)Visibility.DISPLAY_ONLY) || vis.equals((Object)Visibility.OUTPUT_ONLY))) {
            context.addWriteMessage("Visibility " + vis + " is not a valid Visibility for a Skill");
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(vis.getLSTFormat());
        Boolean readOnly = (Boolean)context.getObjectContext().getObject((CDOMObject)skill, ObjectKey.READ_ONLY);
        if (readOnly != null && !vis.equals((Object)Visibility.OUTPUT_ONLY)) {
            sb.append('|').append("READONLY");
        }
        return new String[]{sb.toString()};
    }

    public Class<Skill> getTokenClass() {
        return Skill.class;
    }
}

