/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.List;
import java.util.Set;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.SetFacet;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.analysis.HasAnyFavoredClassFacet;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.ClassFacet;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.core.PCClass;
import pcgen.output.publish.OutputDB;

public class FavoredClassFacet
extends AbstractSourcedListFacet<CharID, PCClass>
implements DataFacetChangeListener<CharID, CDOMObject>,
SetFacet<CharID, PCClass> {
    private HasAnyFavoredClassFacet hasAnyFavoredClassFacet;
    private ClassFacet classFacet;
    private RaceFacet raceFacet;
    private TemplateFacet templateFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        List<CDOMReference<? extends PCClass>> list = cdo.getListFor(ListKey.FAVORED_CLASS);
        if (list != null) {
            for (CDOMReference<? extends PCClass> ref : list) {
                this.addAll(dfce.getCharID(), ref.getContainedObjects(), cdo);
            }
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    public int getFavoredClassLevel(CharID id) {
        Set aList = this.getSet(id);
        int level = 0;
        int max = 0;
        boolean isAny = this.hasAnyFavoredClassFacet.contains(id, Boolean.TRUE);
        block0: for (PCClass cl : aList) {
            for (PCClass pcClass : this.classFacet.getSet(id)) {
                if (isAny) {
                    max = Math.max(max, this.classFacet.getLevel(id, pcClass));
                }
                if (!cl.getKeyName().equals(pcClass.getKeyName())) continue;
                level += this.classFacet.getLevel(id, pcClass);
                continue block0;
            }
        }
        return Math.max(level, max);
    }

    public void setHasAnyFavoredClassFacet(HasAnyFavoredClassFacet hasAnyFavoredClassFacet) {
        this.hasAnyFavoredClassFacet = hasAnyFavoredClassFacet;
    }

    public void setClassFacet(ClassFacet classFacet) {
        this.classFacet = classFacet;
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void setTemplateFacet(TemplateFacet templateFacet) {
        this.templateFacet = templateFacet;
    }

    public void init() {
        this.raceFacet.addDataFacetChangeListener(this);
        this.templateFacet.addDataFacetChangeListener(this);
        OutputDB.register("favoredclass", this);
    }
}

