/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.BonusCheckingFacet;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.PrerequisiteFacet;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.core.QualifiedObject;
import pcgen.core.Vision;
import pcgen.core.prereq.Prerequisite;
import pcgen.util.enumeration.VisionType;

public class VisionFacet
extends AbstractSourcedListFacet<CharID, QualifiedObject<Vision>>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private FormulaResolvingFacet formulaResolvingFacet;
    private BonusCheckingFacet bonusCheckingFacet;
    private PrerequisiteFacet prerequisiteFacet;
    private CDOMObjectConsolidationFacet consolidationFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        Collection mods = cdo.getListMods(Vision.VISIONLIST);
        if (mods != null) {
            CharID id = dfce.getCharID();
            for (CDOMReference ref : mods) {
                Collection<AssociatedPrereqObject> assoc = cdo.getListAssociations(Vision.VISIONLIST, ref);
                for (AssociatedPrereqObject apo : assoc) {
                    List<Prerequisite> prereqs = apo.getPrerequisiteList();
                    for (Vision v : ref.getContainedObjects()) {
                        this.add(id, new QualifiedObject<Vision>(v, prereqs), cdo);
                    }
                }
            }
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    public Collection<Vision> getActiveVision(CharID id) {
        Map componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return Collections.emptyList();
        }
        HashMap<VisionType, Integer> map = new HashMap<VisionType, Integer>();
        for (Map.Entry me : componentMap.entrySet()) {
            QualifiedObject qo = (QualifiedObject)me.getKey();
            for (Object source : me.getValue()) {
                if (!this.prerequisiteFacet.qualifies(id, qo, source)) continue;
                String sourceString = source instanceof CDOMObject ? ((CDOMObject)source).getQualifiedKey() : "";
                Vision v = (Vision)qo.getRawObject();
                Formula distance = v.getDistance();
                int a = this.formulaResolvingFacet.resolve(id, distance, sourceString).intValue();
                VisionType visType = v.getType();
                Integer current = (Integer)map.get(visType);
                if (current != null && current >= a) continue;
                map.put(visType, a);
            }
        }
        for (VisionType vType : VisionType.getAllVisionTypes()) {
            int aVal = (int)this.bonusCheckingFacet.getBonus(id, "VISION", vType.toString());
            if (aVal <= 0) continue;
            Integer current = (Integer)map.get(vType);
            map.put(vType, aVal + (current == null ? 0 : current));
        }
        TreeSet<Vision> returnSet = new TreeSet<Vision>();
        for (Map.Entry me : map.entrySet()) {
            returnSet.add(new Vision((VisionType)me.getKey(), FormulaFactory.getFormulaFor((int)((Integer)me.getValue()))));
        }
        return returnSet;
    }

    public Vision getActiveVision(CharID id, VisionType type) {
        Map componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return null;
        }
        Integer i = null;
        for (Map.Entry me : componentMap.entrySet()) {
            QualifiedObject qo = (QualifiedObject)me.getKey();
            Vision v = (Vision)qo.getRawObject();
            VisionType visType = v.getType();
            if (!type.equals(visType)) continue;
            for (Object source : me.getValue()) {
                if (!this.prerequisiteFacet.qualifies(id, qo, source)) continue;
                String sourceString = source instanceof CDOMObject ? ((CDOMObject)source).getQualifiedKey() : "";
                Formula distance = v.getDistance();
                int a = this.formulaResolvingFacet.resolve(id, distance, sourceString).intValue();
                if (i != null && i >= a) continue;
                i = a;
            }
        }
        int a = (int)this.bonusCheckingFacet.getBonus(id, "VISION", type.toString());
        if (a > 0 && (i == null || i < a)) {
            i = a;
        }
        if (i == null) {
            return null;
        }
        return new Vision(type, FormulaFactory.getFormulaFor((int)i));
    }

    public int getVisionCount(CharID id) {
        return this.getActiveVision(id).size();
    }

    @Override
    protected Map<QualifiedObject<Vision>, Set<Object>> getComponentMap() {
        return new HashMap<QualifiedObject<Vision>, Set<Object>>();
    }

    public void setFormulaResolvingFacet(FormulaResolvingFacet formulaResolvingFacet) {
        this.formulaResolvingFacet = formulaResolvingFacet;
    }

    public void setBonusCheckingFacet(BonusCheckingFacet bonusCheckingFacet) {
        this.bonusCheckingFacet = bonusCheckingFacet;
    }

    public void setPrerequisiteFacet(PrerequisiteFacet prerequisiteFacet) {
        this.prerequisiteFacet = prerequisiteFacet;
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
    }
}

