/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.ListSet;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.PCGenIdentifier;
import pcgen.cdom.facet.base.AbstractDataFacet;

public abstract class AbstractSourcedListFacet<IDT extends PCGenIdentifier, T>
extends AbstractDataFacet<IDT, T> {
    public void add(IDT id, T obj, Object source) {
        boolean fireNew;
        if (obj == null) {
            throw new IllegalArgumentException("Object to add may not be null");
        }
        Map<T, Set<Object>> map = this.getConstructingCachedMap(id);
        WrappedMapSet set = map.get(obj);
        boolean bl = fireNew = set == null;
        if (fireNew) {
            set = new WrappedMapSet(IdentityHashMap.class);
            map.put(obj, (Set<Object>)set);
        }
        set.add((Object)source);
        if (fireNew) {
            this.fireDataFacetChangeEvent(id, obj, 0);
        }
    }

    public void addAll(IDT id, Collection<? extends T> c, Object source) {
        for (T obj : c) {
            this.add(id, obj, source);
        }
    }

    public boolean remove(IDT id, T obj, Object source) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        return componentMap != null && this.processRemoval(id, componentMap, obj, source);
    }

    public void removeAll(IDT id, Collection<T> c, Object source) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            for (T obj : c) {
                this.processRemoval(id, componentMap, obj, source);
            }
        }
    }

    public Map<T, Set<Object>> removeAll(IDT id) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return Collections.emptyMap();
        }
        this.removeCache(id);
        for (T obj : componentMap.keySet()) {
            this.fireDataFacetChangeEvent(id, obj, 1);
        }
        return componentMap;
    }

    public Set<T> getSet(IDT id) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new ListSet(componentMap.keySet()));
    }

    public int getCount(IDT id) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return 0;
        }
        return componentMap.size();
    }

    public boolean isEmpty(IDT id) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        return componentMap == null || componentMap.isEmpty();
    }

    public boolean contains(IDT id, T obj) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        return componentMap != null && componentMap.containsKey(obj);
    }

    private Set<Object> getConstructingCachedSetFor(IDT id, T obj) {
        Map<T, Set<Object>> map = this.getConstructingCachedMap(id);
        WrappedMapSet set = map.get(obj);
        if (set == null) {
            set = new WrappedMapSet(IdentityHashMap.class);
            map.put(obj, (Set<Object>)set);
        }
        return set;
    }

    protected Map<T, Set<Object>> getCachedMap(IDT id) {
        return (Map)this.getCache(id);
    }

    private Map<T, Set<Object>> getConstructingCachedMap(IDT id) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            componentMap = this.getComponentMap();
            this.setCache(id, componentMap);
        }
        return componentMap;
    }

    protected Map<T, Set<Object>> getComponentMap() {
        return new IdentityHashMap();
    }

    @Override
    public void copyContents(IDT source, IDT destination) {
        Map<T, Set<Object>> sourceMap = this.getCachedMap(source);
        if (sourceMap != null) {
            for (Map.Entry<T, Set<Object>> me : sourceMap.entrySet()) {
                T obj = me.getKey();
                Set<Object> sourceSet = me.getValue();
                Set<Object> targetSet = this.getConstructingCachedSetFor(destination, obj);
                targetSet.addAll(sourceSet);
            }
        }
    }

    private boolean processRemoval(IDT id, Map<T, Set<Object>> componentMap, T obj, Object source) {
        if (obj == null) {
            throw new IllegalArgumentException("Object to remove may not be null");
        }
        Set<Object> set = componentMap.get(obj);
        if (set == null) {
            return false;
        }
        boolean returnVal = set.remove(source);
        if (set.isEmpty()) {
            componentMap.remove(obj);
            this.fireDataFacetChangeEvent(id, obj, 1);
            if (componentMap.isEmpty()) {
                this.removeCache(id);
            }
        }
        return returnVal;
    }

    public void removeAll(IDT id, Object source) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            ArrayList<T> removedKeys = new ArrayList<T>();
            Iterator<Map.Entry<T, Set<Object>>> it = componentMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<T, Set<Object>> me = it.next();
                Set<Object> set = me.getValue();
                if (!set.remove(source) || !set.isEmpty()) continue;
                T obj = me.getKey();
                it.remove();
                removedKeys.add(obj);
            }
            if (componentMap.isEmpty()) {
                this.removeCache(id);
            }
            for (Object obj : removedKeys) {
                this.fireDataFacetChangeEvent(id, obj, 1);
            }
        }
    }

    public List<? extends T> getSet(IDT id, Object owner) {
        ArrayList<T> list = new ArrayList<T>();
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            for (Map.Entry<T, Set<Object>> me : componentMap.entrySet()) {
                Set<Object> set = me.getValue();
                if (!set.contains(owner)) continue;
                list.add(me.getKey());
            }
        }
        return Collections.unmodifiableList(list);
    }

    public boolean containsFrom(IDT id, Object owner) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            for (Map.Entry<T, Set<Object>> me : componentMap.entrySet()) {
                Set<Object> set = me.getValue();
                if (!set.contains(owner)) continue;
                return true;
            }
        }
        return false;
    }

    public int getCountFrom(IDT id, CDOMObject owner) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        int count = 0;
        if (componentMap != null) {
            for (Map.Entry<T, Set<Object>> me : componentMap.entrySet()) {
                Set<Object> set = me.getValue();
                if (!set.contains(owner)) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean containsFrom(IDT id, T obj, CDOMObject owner) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            Set<Object> sources = componentMap.get(obj);
            return sources != null && sources.contains(owner);
        }
        return false;
    }

    public Collection<Object> getSources(IDT id, T obj) {
        Set<Object> sources;
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap != null && (sources = componentMap.get(obj)) != null) {
            return Collections.unmodifiableSet(sources);
        }
        return Collections.emptySet();
    }
}

