/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.Serializable;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.VariableContainer;

public abstract class TextProperty
extends PObject
implements Serializable,
Comparable<Object> {
    public TextProperty() {
    }

    public TextProperty(String name) {
        this.setName(name);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj instanceof TextProperty) {
            TextProperty tp = (TextProperty)obj;
            return this.getKeyName().compareTo(tp.getKeyName());
        }
        if (obj instanceof CDOMObject) {
            CDOMObject pObj = (CDOMObject)obj;
            return this.getKeyName().compareToIgnoreCase(pObj.getKeyName());
        }
        return this.getKeyName().compareToIgnoreCase(obj.toString());
    }

    public String getText() {
        return this.getDisplayName();
    }

    public String getParsedText(PlayerCharacter pc, VariableContainer varOwner, CDOMObject qualOwner) {
        return this.getParsedText(pc, this.getText(), varOwner, qualOwner);
    }

    protected String getParsedText(PlayerCharacter pc, String fullDesc, VariableContainer varOwner, CDOMObject qOwner) {
        if (fullDesc == null || fullDesc.equals("")) {
            return "";
        }
        String source = qOwner.getQualifiedKey();
        String retString = "";
        if (this.qualifies(pc, qOwner)) {
            StringTokenizer varTok = new StringTokenizer(fullDesc, "|");
            String description = varTok.nextToken();
            if (varTok.hasMoreTokens()) {
                boolean atLeastOneNonZero = false;
                int[] varValue = null;
                if (varTok.countTokens() != 0) {
                    varValue = new int[varTok.countTokens()];
                    for (int j = 0; j < varValue.length; ++j) {
                        String varToken = varTok.nextToken();
                        int value = varOwner.getVariableValue(varToken, source, pc).intValue();
                        if (value != 0) {
                            atLeastOneNonZero = true;
                        }
                        varValue[j] = value;
                    }
                }
                if (atLeastOneNonZero) {
                    StringBuilder newAbility = new StringBuilder(100);
                    varTok = new StringTokenizer(description, "%", true);
                    int varCount = 0;
                    while (varTok.hasMoreTokens()) {
                        String nextTok = varTok.nextToken();
                        if ("%".equals(nextTok)) {
                            if (varValue != null && varCount < varValue.length) {
                                newAbility.append(varValue[varCount++]);
                                continue;
                            }
                            newAbility.append('%');
                            continue;
                        }
                        newAbility.append(nextTok);
                    }
                    retString = newAbility.toString();
                } else {
                    retString = "";
                }
            } else {
                retString = description;
            }
        }
        return retString;
    }
}

