/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.bonus;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.core.bonus.BonusObj;
import pcgen.core.utils.ParsingSeparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenLibrary;
import pcgen.util.Logging;

public class Bonus {
    static final String BONUS_UNDEFINED = "*UNDEFINED";

    private Bonus() {
    }

    public static List<BonusObj> sortBonusList(List<BonusObj> listToSort) {
        ArrayList<BonusObj> tempList = new ArrayList<BonusObj>();
        for (BonusObj bonus : listToSort) {
            int iFound = 0;
            String bonusInfo = bonus.getBonusInfo();
            for (int ii = 0; ii < tempList.size(); ++ii) {
                BonusObj tempBonus = (BonusObj)tempList.get(ii);
                if (!tempBonus.getDependsOn(bonusInfo)) continue;
                iFound = ii;
            }
            tempList.add(iFound, bonus);
        }
        int iCount = tempList.size();
        int i = 0;
        while (i < iCount) {
            BonusObj bonus = (BonusObj)tempList.get(i);
            if (bonus.getDependsOn("JEPFORMULA")) {
                tempList.remove(i);
                tempList.add(bonus);
                --iCount;
                continue;
            }
            ++i;
        }
        listToSort = tempList;
        ArrayList<BonusObj> tempList2 = new ArrayList<BonusObj>();
        int aSize = listToSort.size();
        for (int i2 = 0; i2 < aSize; ++i2) {
            BonusObj bonus = listToSort.get(i2);
            if (bonus.isValueStatic()) {
                tempList2.add(0, bonus);
                continue;
            }
            tempList2.add(bonus);
        }
        return tempList2;
    }

    public static BonusObj newBonus(LoadContext context, String bonusString) {
        StringTokenizer aTok;
        ParsingSeparator sep = new ParsingSeparator(bonusString, '|');
        if (bonusString.indexOf("|") == bonusString.lastIndexOf("|") && bonusString.indexOf(37) < 0) {
            Logging.errorPrint("Illegal bonus format: " + bonusString);
            return null;
        }
        String bonusName = sep.next();
        try {
            Integer.parseInt(bonusName);
            bonusName = sep.next().toUpperCase();
        }
        catch (NumberFormatException exc) {
            bonusName = bonusName.toUpperCase();
        }
        int equalOffset = -1;
        Class<? extends BonusObj> bEntry = TokenLibrary.getBonus(bonusName);
        String typeOfBonus = bonusName;
        if (bEntry == null) {
            equalOffset = bonusName.indexOf(61);
            if (equalOffset >= 0) {
                typeOfBonus = bonusName.substring(0, equalOffset + 1);
                bEntry = TokenLibrary.getBonus(typeOfBonus);
            }
            if (bEntry == null) {
                typeOfBonus = BONUS_UNDEFINED;
                Logging.errorPrint("Unrecognized bonus: " + bonusString);
                return null;
            }
        }
        String bonusInfo = sep.next();
        String bValue = "0";
        if (sep.hasNext()) {
            bValue = sep.next();
        }
        if (bValue.startsWith("PRE") || bValue.startsWith("!PRE")) {
            Logging.errorPrint("Invalid BONUS has no value: " + bonusString);
            return null;
        }
        bValue = bValue.toUpperCase();
        BonusObj aBonus = null;
        try {
            aBonus = bEntry.newInstance();
        }
        catch (Exception exc) {
            Logging.errorPrint("Could not create bonusObj for:" + bonusString);
            return null;
        }
        aBonus.putOriginalString(bonusString.intern());
        aBonus.setBonusName(bonusName.intern());
        aBonus.setTypeOfBonus(typeOfBonus.intern());
        Formula val = aBonus.setValue(bValue.intern());
        if (!val.isValid()) {
            Logging.errorPrint("Could not create bonusObj for:" + bonusString + " since Formula " + bValue + " is not valid: " + val.toString());
            return null;
        }
        while (sep.hasNext()) {
            boolean result;
            String aString = sep.next().toUpperCase();
            if (PreParserFactory.isPreReqString(aString)) {
                try {
                    PreParserFactory factory = PreParserFactory.getInstance();
                    aBonus.addPrerequisite(factory.parse(aString));
                    continue;
                }
                catch (PersistenceLayerException ple) {
                    Logging.errorPrint(ple.getMessage(), ple);
                    Logging.reportSource(Logging.ERROR, context);
                    return null;
                }
            }
            if (!aString.startsWith("TYPE=") && !aString.startsWith("TYPE.")) continue;
            String bonusType = aString.substring(5);
            int dotLoc = bonusType.indexOf(46);
            if (dotLoc != -1) {
                String stackingFlag = bonusType.substring(dotLoc + 1);
                if (stackingFlag.startsWith("REPLACE")) {
                    aBonus.setStackingFlag(BonusObj.StackType.REPLACE);
                } else if (stackingFlag.startsWith("STACK")) {
                    aBonus.setStackingFlag(BonusObj.StackType.STACK);
                }
            }
            if (result = aBonus.addType(bonusType.intern())) continue;
            Logging.log(Logging.LST_ERROR, "Could not add type " + aString.substring(5) + " to bonusType " + typeOfBonus + " in Bonus.newBonus");
            Logging.reportSource(Logging.LST_ERROR, context);
            return null;
        }
        if (equalOffset >= 0) {
            aBonus.setVariable(bonusName.substring(equalOffset + 1).intern());
        }
        if (!aBonus.requiresRealCaseTarget()) {
            bonusInfo = bonusInfo.toUpperCase();
        }
        if (!(aTok = new StringTokenizer(bonusInfo, ",")).hasMoreTokens()) {
            Logging.log(Logging.LST_ERROR, "Could not parse empty target " + " from BONUS:" + bonusString);
            Logging.reportSource(Logging.LST_ERROR, context);
            return null;
        }
        LstUtils.deprecationCheck(aBonus, bonusName, bonusString);
        while (aTok.hasMoreTokens()) {
            String token = aTok.nextToken();
            boolean result = aBonus.parseToken(context, token);
            if (result) continue;
            Logging.log(Logging.LST_ERROR, "Could not parse token " + token + " from BONUS:" + bonusString);
            Logging.reportSource(Logging.LST_ERROR, context);
            return null;
        }
        return aBonus;
    }
}

