/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.MasterListInterface;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SystemCollections;
import pcgen.core.npcgen.ClassData;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.spell.Spell;
import pcgen.util.Logging;
import pcgen.util.enumeration.Visibility;

class ClassDataHandler
extends DefaultHandler {
    private List<ClassData> theList;
    private GameMode theGameMode = null;
    private boolean theValidFlag = false;
    private ParserState theState = ParserState.INIT;
    private ClassData theCurrentData = null;
    private AbilityCategory theCurrentCategory = null;
    private SpellType theCurrentSpellType = SpellType.KNOWN;
    private int theCurrentLevel = -1;
    private transient int remainingWeight = -1;
    private transient List<String> removeList = new ArrayList<String>();

    public ClassDataHandler(GameMode aMode, List<ClassData> aList) {
        this.theGameMode = aMode;
        this.theList = aList;
    }

    @Override
    public void startElement(String uri, String localName, String aName, Attributes anAttrs) throws SAXException {
        if (this.theState == ParserState.INIT && "class_data".equals(aName)) {
            if (anAttrs != null) {
                String gm = anAttrs.getValue("game_mode");
                if (!SystemCollections.getGameModeNamed(gm).equals(this.theGameMode)) {
                    throw new IllegalArgumentException("Incorrect game mode");
                }
                this.theValidFlag = true;
            }
            return;
        }
        if (!this.theValidFlag) {
            throw new SAXException("NPCGen.Options.InvalidFileFormat");
        }
        if (this.theState == ParserState.INIT) {
            if ("class".equals(aName) && anAttrs != null) {
                String classKey = anAttrs.getValue("key");
                PCClass pcClass = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, classKey);
                if (pcClass == null) {
                    Logging.errorPrintLocalised("Exceptions.PCGenParser.ClassNotFound", classKey);
                } else {
                    this.theCurrentData = new ClassData(pcClass);
                    this.theState = ParserState.CLASSDATA;
                }
            }
        } else if (this.theState == ParserState.CLASSDATA) {
            if ("stats".equals(aName)) {
                this.theState = ParserState.STATDATA;
            } else if ("skills".equals(aName)) {
                this.theState = ParserState.SKILLDATA;
            } else if ("abilities".equals(aName)) {
                String catName;
                this.theState = ParserState.ABILITYDATA;
                this.theCurrentCategory = AbilityCategory.FEAT;
                if (anAttrs != null && (catName = anAttrs.getValue("category")) != null) {
                    this.theCurrentCategory = SettingsHandler.getGame().getAbilityCategory(catName);
                }
            } else if ("spells".equals(aName)) {
                String bookName;
                this.theState = ParserState.SPELLDATA;
                this.theCurrentSpellType = SpellType.KNOWN;
                if (anAttrs != null && (bookName = anAttrs.getValue("type")) != null && "Prepared Spells".equals(bookName)) {
                    this.theCurrentSpellType = SpellType.PREPARED;
                }
            } else if ("subclasses".equals(aName)) {
                this.theState = ParserState.SUBCLASSDATA;
            }
        } else if (this.theState == ParserState.STATDATA) {
            if ("stat".equals(aName) && anAttrs != null) {
                int weight = this.getWeight(anAttrs);
                String statAbbr = anAttrs.getValue("value");
                if (statAbbr != null) {
                    PCStat stat = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, statAbbr);
                    this.theCurrentData.addStat(stat, weight);
                }
            }
        } else if (this.theState == ParserState.SKILLDATA) {
            if ("skill".equals(aName) && anAttrs != null) {
                int weight = this.getWeight(anAttrs);
                String key = anAttrs.getValue("value");
                if (key != null) {
                    if ("*".equals(key)) {
                        this.remainingWeight = weight;
                    } else if (key.startsWith("TYPE")) {
                        List<Skill> skillsOfType = Globals.getPObjectsOfType(Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Skill.class), key.substring(5));
                        if (skillsOfType.size() == 0) {
                            Logging.debugPrint("NPCGenerator: No skills of type found (" + key + ")");
                        }
                    } else {
                        Skill skill = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Skill.class, key);
                        if (skill == null) {
                            Logging.debugPrint("NPCGenerator: Skill not found (" + key + ")");
                        }
                    }
                    if (weight > 0 && !key.equals("*")) {
                        this.theCurrentData.addSkill(key, weight);
                    } else {
                        this.removeList.add(key);
                    }
                }
            }
        } else if (this.theState == ParserState.ABILITYDATA) {
            if ("ability".equals(aName) && anAttrs != null) {
                int weight = this.getWeight(anAttrs);
                String key = anAttrs.getValue("value");
                if (key != null) {
                    if ("*".equals(key)) {
                        this.remainingWeight = weight;
                    } else if (key.startsWith("TYPE")) {
                        Type type = Type.getConstant(key.substring(5));
                        for (Ability ability : Globals.getContext().getReferenceContext().getManufacturer(Ability.class, this.theCurrentCategory).getAllObjects()) {
                            if (!ability.containsInList(ListKey.TYPE, type) || ability.getSafe(ObjectKey.VISIBILITY) != Visibility.DEFAULT) continue;
                            if (weight > 0) {
                                this.theCurrentData.addAbility(this.theCurrentCategory, ability, weight);
                                continue;
                            }
                            this.removeList.add(ability.getKeyName());
                        }
                    } else {
                        Ability ability = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, this.theCurrentCategory, key);
                        if (ability == null) {
                            Logging.debugPrint("Ability (" + key + ") not found");
                        } else if (weight > 0) {
                            this.theCurrentData.addAbility(this.theCurrentCategory, ability, weight);
                        } else {
                            this.removeList.add(ability.getKeyName());
                        }
                    }
                }
            }
        } else if (this.theState == ParserState.SPELLDATA) {
            String lvlStr;
            if ("level".equals(aName) && anAttrs != null && (lvlStr = anAttrs.getValue("id")) != null) {
                this.theCurrentLevel = Integer.parseInt(lvlStr);
                this.theState = ParserState.SPELLLEVELDATA;
            }
        } else if (this.theState == ParserState.SPELLLEVELDATA) {
            if ("spell".equals(aName) && anAttrs != null) {
                int weight = this.getWeight(anAttrs);
                String key = anAttrs.getValue("name");
                if (key != null) {
                    if ("*".equals(key)) {
                        this.remainingWeight = weight;
                    } else if (!key.startsWith("SCHOOL")) {
                        Spell spell = Globals.getSpellKeyed(key);
                        if (spell != null) {
                            if (this.theCurrentSpellType == SpellType.KNOWN) {
                                this.theCurrentData.addKnownSpell(this.theCurrentLevel, spell, weight);
                            } else if (this.theCurrentSpellType == SpellType.PREPARED) {
                                this.theCurrentData.addPreparedSpell(this.theCurrentLevel, spell, weight);
                            }
                        } else {
                            Logging.errorPrint("Spell \"" + key + "\" not found.");
                        }
                    }
                }
            }
        } else if (this.theState == ParserState.SUBCLASSDATA && "subclass".equals(aName) && anAttrs != null) {
            int weight = this.getWeight(anAttrs);
            String key = anAttrs.getValue("value");
            this.theCurrentData.addSubClass(key, weight);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.theState == ParserState.INIT) {
            return;
        }
        if ("skills".equals(qName) && this.theState == ParserState.SKILLDATA) {
            if (this.remainingWeight > 0) {
                for (Skill skill : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Skill.class)) {
                    if (skill.getSafe(ObjectKey.VISIBILITY) != Visibility.DEFAULT) continue;
                    this.theCurrentData.addSkill(skill.getKeyName(), this.remainingWeight);
                }
                this.remainingWeight = -1;
            }
            for (String remove : this.removeList) {
                this.theCurrentData.removeSkill(remove);
            }
            this.removeList = new ArrayList<String>();
            this.theState = ParserState.CLASSDATA;
        } else if ("abilities".equals(qName) && this.theState == ParserState.ABILITYDATA) {
            if (this.remainingWeight > 0) {
                for (Ability ability : Globals.getContext().getReferenceContext().getManufacturer(Ability.class, this.theCurrentCategory).getAllObjects()) {
                    if (ability.getSafe(ObjectKey.VISIBILITY) != Visibility.DEFAULT) continue;
                    this.theCurrentData.addAbility(this.theCurrentCategory, ability, this.remainingWeight);
                }
                this.remainingWeight = -1;
            }
            for (String remove : this.removeList) {
                Ability ability = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, this.theCurrentCategory, remove);
                this.theCurrentData.removeAbility(this.theCurrentCategory, ability);
            }
            this.removeList = new ArrayList<String>();
            this.theCurrentCategory = null;
            this.theState = ParserState.CLASSDATA;
        } else if ("class".equals(qName) && this.theState != ParserState.INIT) {
            this.theList.add(this.theCurrentData);
            this.theState = ParserState.INIT;
        } else if ("stats".equals(qName)) {
            this.theState = ParserState.CLASSDATA;
        } else if ("level".equals(qName)) {
            if (this.remainingWeight > 0) {
                List<Spell> allSpells = ClassDataHandler.getSpellsIn(this.theCurrentLevel, Collections.singletonList(this.theCurrentData.getPCClass().get(ObjectKey.CLASS_SPELLLIST)));
                for (Spell spell : allSpells) {
                    if (this.theCurrentSpellType == SpellType.KNOWN) {
                        this.theCurrentData.addKnownSpell(this.theCurrentLevel, spell, this.remainingWeight);
                        continue;
                    }
                    if (this.theCurrentSpellType != SpellType.PREPARED) continue;
                    this.theCurrentData.addPreparedSpell(this.theCurrentLevel, spell, this.remainingWeight);
                }
                this.remainingWeight = -1;
            }
            for (String remove : this.removeList) {
                Spell spell;
                spell = Globals.getSpellKeyed(remove);
                if (this.theCurrentSpellType == SpellType.KNOWN) {
                    this.theCurrentData.removeKnownSpell(this.theCurrentLevel, spell);
                    continue;
                }
                if (this.theCurrentSpellType != SpellType.PREPARED) continue;
                this.theCurrentData.removeKnownSpell(this.theCurrentLevel, spell);
            }
            this.removeList = new ArrayList<String>();
            this.theCurrentLevel = -1;
            this.theState = ParserState.SPELLDATA;
        } else if ("spells".equals(qName)) {
            this.theState = ParserState.CLASSDATA;
            this.theCurrentSpellType = SpellType.KNOWN;
        } else if ("subclasses".equals(qName)) {
            this.theState = ParserState.CLASSDATA;
        }
    }

    private int getWeight(Attributes anAttrs) {
        int weight = 1;
        String wtStr = anAttrs.getValue("weight");
        if (wtStr != null) {
            weight = Integer.parseInt(wtStr.trim());
        }
        return weight;
    }

    public static List<Spell> getSpellsIn(int level, List<? extends CDOMList<Spell>> spellLists) {
        MasterListInterface masterLists = Globals.getMasterLists();
        ArrayList useLists = new ArrayList();
        block0: for (CDOMReference<CDOMList<?>> ref : masterLists.getActiveLists()) {
            for (CDOMList<Spell> cDOMList : spellLists) {
                if (!ref.contains(cDOMList)) continue;
                useLists.add(ref);
                continue block0;
            }
        }
        boolean allLevels = level == -1;
        HashSet<Spell> spellList = new HashSet<Spell>();
        for (CDOMReference cDOMReference : useLists) {
            block3: for (Spell spell : masterLists.getObjects(cDOMReference)) {
                Collection<AssociatedPrereqObject> assoc = masterLists.getAssociations(cDOMReference, spell);
                for (AssociatedPrereqObject apo : assoc) {
                    if (!PrereqHandler.passesAll(apo.getPrerequisiteList(), (PlayerCharacter)null, null)) continue;
                    int lvl = apo.getAssociation(AssociationKey.SPELL_LEVEL);
                    if (!allLevels && level != lvl) continue;
                    spellList.add(spell);
                    continue block3;
                }
            }
        }
        return new ArrayList<Spell>(spellList);
    }

    private static enum SpellType {
        KNOWN,
        PREPARED;

    }

    private static enum ParserState {
        INIT,
        CLASSDATA,
        STATDATA,
        SKILLDATA,
        ABILITYDATA,
        SPELLDATA,
        SPELLLEVELDATA,
        SUBCLASSDATA;

    }
}

