/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Campaign;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.gui2.converter.panel.ConvertSubPanel;
import pcgen.gui2.tools.Utility;
import pcgen.system.PCGenSettings;

public class CampaignPanel
extends ConvertSubPanel {
    private List<Campaign> gameModeCampaigns;
    private String folderName;

    @Override
    public boolean autoAdvance(CDOMObject pc) {
        return false;
    }

    @Override
    public boolean returnAllowed() {
        return true;
    }

    @Override
    public boolean performAnalysis(CDOMObject pc) {
        GameMode game = pc.get(ObjectKey.GAME_MODE);
        ArrayList<String> gameModeList = new ArrayList<String>();
        gameModeList.addAll(game.getAllowedModes());
        File sourceFolder = pc.get(ObjectKey.DIRECTORY);
        this.folderName = sourceFolder.toURI().toString();
        List<Campaign> allCampaigns = Globals.getCampaignList();
        this.gameModeCampaigns = new ArrayList<Campaign>();
        for (Campaign campaign : allCampaigns) {
            if (!campaign.containsAnyInList(ListKey.GAME_MODE, gameModeList) || !campaign.getSourceURI().toString().startsWith(this.folderName)) continue;
            this.gameModeCampaigns.add(campaign);
        }
        return false;
    }

    @Override
    public void setupDisplay(JPanel panel, final CDOMObject pc) {
        panel.setLayout(new GridBagLayout());
        JLabel introLabel = new JLabel("Please select the Campaign(s) to Convert:");
        GridBagConstraints gbc = new GridBagConstraints();
        Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 0.0, 2, 18);
        gbc.insets = new Insets(25, 25, 5, 25);
        panel.add((Component)introLabel, gbc);
        final CampaignTableModel model = new CampaignTableModel(this.gameModeCampaigns, this.folderName);
        final JTable table = new JTable(model){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                String tip = String.valueOf(this.getValueAt(rowIndex, colIndex));
                return tip;
            }
        };
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                pc.removeListFor(ListKey.CAMPAIGN);
                int[] selRows = table.getSelectedRows();
                if (selRows.length == 0) {
                    CampaignPanel.this.saveSourceSelection(pc);
                    CampaignPanel.this.fireProgressEvent(1);
                } else {
                    for (int row : selRows) {
                        Campaign selCampaign = (Campaign)model.getValueAt(row, 0);
                        pc.addToListFor(ListKey.CAMPAIGN, selCampaign);
                    }
                    CampaignPanel.this.saveSourceSelection(pc);
                    CampaignPanel.this.fireProgressEvent(0);
                }
            }
        });
        JScrollPane listScroller = new JScrollPane(table);
        Utility.buildRelativeConstraints(gbc, 0, 0, 1.0, 1.0);
        gbc.fill = 1;
        panel.add((Component)listScroller, gbc);
        this.initSourceSelection(model, table);
    }

    private void initSourceSelection(CampaignTableModel model, JTable table) {
        String[] sources;
        PCGenSettings context = PCGenSettings.getInstance();
        String sourceString = context.initProperty("pcgen.convert.sources", "");
        block0: for (String srcName : sources = sourceString.split("\\|")) {
            for (Campaign camp : this.gameModeCampaigns) {
                if (!camp.toString().equals(srcName)) continue;
                for (int i = 0; i < model.getRowCount(); ++i) {
                    if (!camp.equals(model.getValueAt(i, 0))) continue;
                    table.getSelectionModel().addSelectionInterval(i, i);
                    continue block0;
                }
            }
        }
    }

    private void saveSourceSelection(CDOMObject pc) {
        List<Campaign> selCampaigns = pc.getSafeListFor(ListKey.CAMPAIGN);
        PCGenSettings context = PCGenSettings.getInstance();
        context.setProperty("pcgen.convert.sources", StringUtils.join(selCampaigns, "|"));
    }

    public class CampaignTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Campaign", "Location"};
        private Object[][] rowData;

        public CampaignTableModel(List<Campaign> campList, String prefix) {
            this.rowData = new Object[campList.size()][2];
            int i = 0;
            for (Campaign campaign : campList) {
                this.rowData[i++] = new Object[]{campaign, campaign.getSourceURI().toString().substring(prefix.length())};
            }
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        @Override
        public int getRowCount() {
            return this.rowData.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.rowData[row][col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }
    }
}

