/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.equip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.EquipModFacade;
import pcgen.facade.core.EquipmentBuilderFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.SizeAdjustmentFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DefaultReferenceFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.gui2.equip.EquipQualifiedTreeCellRenderer;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilterBar;
import pcgen.gui2.filter.FilteredListFacade;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.models.CharacterComboBoxModel;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.FontManipulation;
import pcgen.gui2.util.TreeColumnCellRenderer;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.DefaultDataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.LanguageBundle;

public class EquipCustomPanel
extends FlippingSplitPane {
    private final FilteredTreeViewTable<Object, EquipModFacade> availableTable;
    private final FilteredTreeViewTable<Object, EquipModFacade> selectedTable;
    private final JButton nameButton;
    private final JButton spropButton;
    private final JButton costButton;
    private final JButton weightButton;
    private final JButton damageButton;
    private final JComboBox headCombo;
    private final JComboBox sizeCombo;
    private final JButton addButton;
    private final JButton removeButton;
    private final InfoPane equipModInfoPane;
    private final InfoPane equipInfoPane;
    private final CharacterFacade character;
    private TreeColumnCellRenderer renderer;
    private NameAction nameAction;
    private SPropAction spropAction;
    private CostAction costAction;
    private WeightAction weightAction;
    private DamageAction damageAction;
    private AddEqmodAction addAction;
    private RemoveEqmodAction removeAction;
    private EquipmentBuilderFacade builder;
    private EquipInfoHandler equipInfoHandler;
    private ListFacade<EquipmentBuilderFacade.EquipmentHead> validHeads;
    private HeadBoxModel headBoxModel;
    private SizeBoxModel sizeBoxModel;
    private EquipmentBuilderFacade.EquipmentHead currentHead = EquipmentBuilderFacade.EquipmentHead.PRIMARY;
    private Map<EquipmentBuilderFacade.EquipmentHead, EquipModTreeViewModel> availEqmodModelMap;
    private Map<EquipmentBuilderFacade.EquipmentHead, EquipModTreeViewModel> selectedEqmodModelMap;

    public EquipCustomPanel(CharacterFacade character, EquipmentBuilderFacade builder) {
        super("customEquip");
        this.character = character;
        this.builder = builder;
        this.validHeads = new DefaultListFacade<EquipmentBuilderFacade.EquipmentHead>(builder.getEquipmentHeads());
        this.availableTable = new FilteredTreeViewTable();
        this.selectedTable = new FilteredTreeViewTable();
        this.nameButton = new JButton();
        this.spropButton = new JButton();
        this.costButton = new JButton();
        this.weightButton = new JButton();
        this.damageButton = new JButton();
        this.headCombo = new JComboBox();
        this.sizeCombo = new JComboBox();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.equipModInfoPane = new InfoPane(LanguageBundle.getString("in_igEqModInfo"));
        this.equipInfoPane = new InfoPane(LanguageBundle.getString("in_igEqInfo"));
        this.renderer = new EquipQualifiedTreeCellRenderer(character, builder.getEquipment());
        this.nameAction = new NameAction();
        this.spropAction = new SPropAction();
        this.costAction = new CostAction();
        this.weightAction = new WeightAction();
        this.damageAction = new DamageAction();
        this.addAction = new AddEqmodAction();
        this.removeAction = new RemoveEqmodAction();
        this.initHeadMaps();
        this.initComponents();
        this.initDefaults();
    }

    private void initHeadMaps() {
        this.availEqmodModelMap = new HashMap<EquipmentBuilderFacade.EquipmentHead, EquipModTreeViewModel>();
        this.selectedEqmodModelMap = new HashMap<EquipmentBuilderFacade.EquipmentHead, EquipModTreeViewModel>();
        for (EquipmentBuilderFacade.EquipmentHead head : this.validHeads) {
            this.availEqmodModelMap.put(head, new EquipModTreeViewModel(this.character, this.builder, head, true));
            this.selectedEqmodModelMap.put(head, new EquipModTreeViewModel(this.character, this.builder, head, false));
        }
    }

    private void initComponents() {
        JPanel upperPanel = new JPanel(new BorderLayout());
        this.setTopComponent(upperPanel);
        this.setOrientation(0);
        Box bannerBox = Box.createHorizontalBox();
        bannerBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bannerBox.add(Box.createHorizontalGlue());
        JLabel baseItemLabel = new JLabel(LanguageBundle.getString("in_EqBuilder_BaseItem"));
        FontManipulation.large(baseItemLabel);
        bannerBox.add(baseItemLabel);
        bannerBox.add(Box.createHorizontalStrut(5));
        JLabel baseItemName = new JLabel(this.builder.getBaseItemName());
        FontManipulation.large(baseItemName);
        FontManipulation.title(baseItemName);
        bannerBox.add(baseItemName);
        if (this.validHeads.getSize() > 1) {
            bannerBox.add(Box.createHorizontalStrut(45));
            JLabel headLabel = new JLabel(LanguageBundle.getString("in_EqBuilder_Head"));
            FontManipulation.large(headLabel);
            bannerBox.add(headLabel);
            bannerBox.add(Box.createHorizontalStrut(5));
            Dimension prefDim = this.headCombo.getPreferredSize();
            prefDim.width += 15;
            this.headCombo.setMaximumSize(prefDim);
            bannerBox.add(this.headCombo);
        }
        bannerBox.add(Box.createHorizontalGlue());
        upperPanel.add((Component)bannerBox, "North");
        FlippingSplitPane topPane = new FlippingSplitPane("equipCustTop");
        upperPanel.add((Component)topPane, "Center");
        JPanel availPanel = new JPanel(new BorderLayout());
        FilterBar<Object, Object> bar = new FilterBar<Object, Object>();
        bar.addDisplayableFilter(new SearchFilterPanel());
        availPanel.add(bar, "North");
        this.availableTable.setDisplayableFilter(bar);
        this.availableTable.setTreeViewModel(this.availEqmodModelMap.get((Object)this.currentHead));
        this.availableTable.setTreeCellRenderer(this.renderer);
        availPanel.add((Component)new JScrollPane(this.availableTable), "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        this.addButton.setHorizontalTextPosition(10);
        this.addButton.setAction(this.addAction);
        box.add(this.addButton);
        box.add(Box.createHorizontalStrut(5));
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        availPanel.add((Component)box, "South");
        topPane.setLeftComponent(availPanel);
        JPanel selPanel = new JPanel(new BorderLayout());
        Box equipButtonBox = Box.createHorizontalBox();
        equipButtonBox.add(Box.createHorizontalGlue());
        this.nameButton.setHorizontalTextPosition(10);
        this.nameButton.setAction(this.nameAction);
        equipButtonBox.add(this.nameButton);
        equipButtonBox.add(Box.createHorizontalStrut(5));
        this.spropButton.setHorizontalTextPosition(10);
        this.spropButton.setAction(this.spropAction);
        equipButtonBox.add(this.spropButton);
        equipButtonBox.add(Box.createHorizontalStrut(5));
        this.costButton.setHorizontalTextPosition(10);
        this.costButton.setAction(this.costAction);
        equipButtonBox.add(this.costButton);
        equipButtonBox.add(Box.createHorizontalStrut(5));
        this.weightButton.setHorizontalTextPosition(10);
        this.weightButton.setAction(this.weightAction);
        equipButtonBox.add(this.weightButton);
        if (this.builder.isWeapon()) {
            equipButtonBox.add(Box.createHorizontalStrut(5));
            this.damageButton.setHorizontalTextPosition(10);
            this.damageButton.setAction(this.damageAction);
            equipButtonBox.add(this.damageButton);
        }
        if (this.builder.isResizable()) {
            JPanel sizePanel = new JPanel();
            JLabel sizeLabel = new JLabel(LanguageBundle.getString("in_EqBuilder_Size"));
            sizePanel.add(sizeLabel);
            sizePanel.add(this.sizeCombo);
            equipButtonBox.add(Box.createHorizontalStrut(5));
            equipButtonBox.add(sizePanel);
        }
        equipButtonBox.add(Box.createHorizontalGlue());
        equipButtonBox.setBorder(new EmptyBorder(5, 0, 0, 0));
        selPanel.add((Component)equipButtonBox, "North");
        this.selectedTable.setTreeViewModel(this.selectedEqmodModelMap.get((Object)this.currentHead));
        this.selectedTable.setTreeCellRenderer(this.renderer);
        selPanel.add((Component)new JScrollPane(this.selectedTable), "Center");
        box = Box.createHorizontalBox();
        this.removeButton.setHorizontalTextPosition(11);
        this.removeButton.setAction(this.removeAction);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.removeButton);
        box.add(Box.createHorizontalGlue());
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        selPanel.add((Component)box, "South");
        topPane.setRightComponent(selPanel);
        FlippingSplitPane bottomPane = new FlippingSplitPane("equipCustBottom");
        bottomPane.setLeftComponent(this.equipModInfoPane);
        bottomPane.setRightComponent(this.equipInfoPane);
        this.setBottomComponent(bottomPane);
        this.setResizeWeight(0.75);
    }

    private void initDefaults() {
        this.equipInfoHandler = new EquipInfoHandler(this.character, this.builder);
        this.selectedTable.getSelectionModel().addListSelectionListener(this.equipInfoHandler);
        EquipModInfoHandler eqModInfoHandler = new EquipModInfoHandler(this.character, this.builder);
        this.availableTable.getSelectionModel().addListSelectionListener(eqModInfoHandler);
        this.selectedTable.getSelectionModel().addListSelectionListener(eqModInfoHandler);
        this.availableTable.addActionListener(this.addAction);
        this.sizeBoxModel = new SizeBoxModel();
        this.sizeCombo.setModel(this.sizeBoxModel);
        this.headBoxModel = new HeadBoxModel();
        this.headCombo.setModel(this.headBoxModel);
    }

    private class SizeBoxModel
    extends CharacterComboBoxModel<SizeAdjustmentFacade> {
        public SizeBoxModel() {
            this.setListFacade(EquipCustomPanel.this.character.getDataSet().getSizes());
            this.setReference(EquipCustomPanel.this.builder.getSizeRef());
        }

        @Override
        public void setSelectedItem(Object anItem) {
            EquipCustomPanel.this.builder.setSize((SizeAdjustmentFacade)anItem);
        }

        @Override
        public void referenceChanged(ReferenceEvent<SizeAdjustmentFacade> e) {
            super.referenceChanged(e);
            EquipCustomPanel.this.equipInfoHandler.refreshInfo();
        }
    }

    private class HeadBoxModel
    extends CharacterComboBoxModel<EquipmentBuilderFacade.EquipmentHead> {
        private DefaultReferenceFacade<EquipmentBuilderFacade.EquipmentHead> headRef;

        public HeadBoxModel() {
            this.setListFacade(EquipCustomPanel.this.validHeads);
            this.headRef = new DefaultReferenceFacade<EquipmentBuilderFacade.EquipmentHead>(EquipCustomPanel.this.currentHead);
            this.setReference(this.headRef);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            EquipmentBuilderFacade.EquipmentHead head = (EquipmentBuilderFacade.EquipmentHead)((Object)anItem);
            EquipCustomPanel.this.currentHead = head;
            this.headRef.setReference(head);
            EquipCustomPanel.this.availableTable.setTreeViewModel((TreeViewModel)EquipCustomPanel.this.availEqmodModelMap.get((Object)EquipCustomPanel.this.currentHead));
            EquipCustomPanel.this.selectedTable.setTreeViewModel((TreeViewModel)EquipCustomPanel.this.selectedEqmodModelMap.get((Object)EquipCustomPanel.this.currentHead));
        }

        @Override
        public void referenceChanged(ReferenceEvent<EquipmentBuilderFacade.EquipmentHead> e) {
            super.referenceChanged(e);
        }
    }

    private static enum EquipModTreeView implements TreeView<EquipModFacade>
    {
        NAME(LanguageBundle.getString("in_nameLabel")),
        TYPE_NAME(LanguageBundle.getString("in_typeName")),
        SOURCE_NAME(LanguageBundle.getString("in_sourceName"));

        private String name;

        private EquipModTreeView(String name) {
            this.name = name;
        }

        @Override
        public String getViewName() {
            return this.name;
        }

        @Override
        public List<TreeViewPath<EquipModFacade>> getPaths(EquipModFacade pobj) {
            switch (this) {
                case NAME: {
                    return Collections.singletonList(new TreeViewPath<EquipModFacade>(pobj));
                }
                case TYPE_NAME: {
                    TreeViewPath<EquipModFacade> path = EquipModTreeView.createTreeViewPath(pobj, pobj.getDisplayType().split("\\."));
                    return Arrays.asList(path);
                }
                case SOURCE_NAME: {
                    return Collections.singletonList(new TreeViewPath<EquipModFacade>(pobj, (Object)pobj.getSourceForNodeDisplay()));
                }
            }
            throw new InternalError();
        }

        protected static TreeViewPath<EquipModFacade> createTreeViewPath(EquipModFacade pobj, Object ... path) {
            if (path.length == 0) {
                return new TreeViewPath<EquipModFacade>(pobj);
            }
            if (path.length > 2) {
                return new TreeViewPath<EquipModFacade>(pobj, path[0], path[1]);
            }
            return new TreeViewPath<EquipModFacade>(pobj, path);
        }
    }

    private static class EquipModTreeViewModel
    implements TreeViewModel<EquipModFacade>,
    DataView<EquipModFacade>,
    Filter<EquipmentBuilderFacade, EquipModFacade>,
    ListListener<EquipModFacade> {
        private static final DefaultListFacade<? extends TreeView<EquipModFacade>> treeViews = new DefaultListFacade<EquipModTreeView>(Arrays.asList(EquipModTreeView.values()));
        private final List<DefaultDataViewColumn> columns;
        private final boolean isAvailModel;
        private FilteredListFacade<EquipmentBuilderFacade, EquipModFacade> equipMods;
        private EquipmentBuilderFacade builder;
        private EquipmentBuilderFacade.EquipmentHead head;

        public EquipModTreeViewModel(CharacterFacade character, EquipmentBuilderFacade builder, EquipmentBuilderFacade.EquipmentHead head, boolean isAvailModel) {
            this.builder = builder;
            this.head = head;
            this.isAvailModel = isAvailModel;
            this.equipMods = new FilteredListFacade();
            this.equipMods.setContext(builder);
            this.equipMods.setFilter(this);
            if (isAvailModel) {
                ListFacade<EquipModFacade> eqModList = builder.getAvailList(head);
                this.equipMods.setDelegate(eqModList);
                builder.getAvailList(head).addListListener(this);
                this.columns = Arrays.asList(new DefaultDataViewColumn("in_source", String.class, false));
            } else {
                this.columns = Arrays.asList(new DefaultDataViewColumn("in_source", String.class, false));
            }
        }

        @Override
        public ListFacade<? extends TreeView<EquipModFacade>> getTreeViews() {
            return treeViews;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return 0;
        }

        @Override
        public DataView<EquipModFacade> getDataView() {
            return this;
        }

        @Override
        public ListFacade<EquipModFacade> getDataModel() {
            if (this.isAvailModel) {
                return this.equipMods;
            }
            return this.builder.getSelectedList(this.head);
        }

        @Override
        public List<?> getData(EquipModFacade obj) {
            return Arrays.asList(obj.getSource());
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return this.columns;
        }

        @Override
        public void elementAdded(ListEvent<EquipModFacade> e) {
        }

        @Override
        public void elementRemoved(ListEvent<EquipModFacade> e) {
        }

        @Override
        public void elementsChanged(ListEvent<EquipModFacade> e) {
        }

        @Override
        public void elementModified(ListEvent<EquipModFacade> e) {
        }

        @Override
        public boolean accept(EquipmentBuilderFacade context, EquipModFacade element) {
            return true;
        }

        @Override
        public String getPrefsKey() {
            return this.isAvailModel ? "EqModTreeAvail" : "EqModTreeSelected";
        }
    }

    private class DamageAction
    extends AbstractAction {
        public DamageAction() {
            super(LanguageBundle.getString("in_igInfoLabelTextDamage"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object result = JOptionPane.showInputDialog(EquipCustomPanel.this, LanguageBundle.getString("in_eqCust_NewDamage"), "PCGen", 3, null, null, EquipCustomPanel.this.builder.getDamage());
            String selectedValue = result == null ? "" : result.toString();
            EquipCustomPanel.this.builder.setDamage(selectedValue);
            EquipCustomPanel.this.equipInfoHandler.refreshInfo();
        }
    }

    private class WeightAction
    extends AbstractAction {
        public WeightAction() {
            super(LanguageBundle.getString("in_igEqModelColWeight"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object result = JOptionPane.showInputDialog(EquipCustomPanel.this, LanguageBundle.getString("in_eqCust_NewWeight"), "PCGen", 3, null, null, Float.valueOf(EquipCustomPanel.this.character.getInfoFactory().getWeight(EquipCustomPanel.this.builder.getEquipment())));
            String selectedValue = result == null ? "" : result.toString();
            EquipCustomPanel.this.builder.setWeight(selectedValue);
            EquipCustomPanel.this.equipInfoHandler.refreshInfo();
        }
    }

    private class CostAction
    extends AbstractAction {
        public CostAction() {
            super(LanguageBundle.getString("in_igEqModelColCost"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object result = JOptionPane.showInputDialog(EquipCustomPanel.this, LanguageBundle.getString("in_eqCust_NewCost"), "PCGen", 3, null, null, Float.valueOf(EquipCustomPanel.this.character.getInfoFactory().getCost(EquipCustomPanel.this.builder.getEquipment())));
            String selectedValue = result == null ? "" : result.toString();
            EquipCustomPanel.this.builder.setCost(selectedValue);
            EquipCustomPanel.this.equipInfoHandler.refreshInfo();
        }
    }

    private class SPropAction
    extends AbstractAction {
        public SPropAction() {
            super(LanguageBundle.getString("in_eqCust_SProp"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object result = JOptionPane.showInputDialog(EquipCustomPanel.this, LanguageBundle.getString("in_eqCust_NewSProp"), "PCGen", 3, null, null, EquipCustomPanel.this.builder.getEquipment().getRawSpecialProperties());
            String selectedValue = result == null ? "" : result.toString();
            EquipCustomPanel.this.builder.setSProp(selectedValue);
            EquipCustomPanel.this.equipInfoHandler.refreshInfo();
        }
    }

    private class NameAction
    extends AbstractAction {
        public NameAction() {
            super(LanguageBundle.getString("in_nameLabel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object result = JOptionPane.showInputDialog(EquipCustomPanel.this, LanguageBundle.getString("in_eqCust_NewName"), "PCGen", 3, null, null, EquipCustomPanel.this.builder.getEquipment().toString());
            String selectedValue = result == null ? "" : result.toString();
            EquipCustomPanel.this.builder.setName(selectedValue);
            EquipCustomPanel.this.equipInfoHandler.refreshInfo();
        }
    }

    private class RemoveEqmodAction
    extends AbstractAction {
        public RemoveEqmodAction() {
            super(LanguageBundle.getString("in_eqCust_RemovePrimary"));
            this.putValue("SmallIcon", Icons.Back16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = EquipCustomPanel.this.selectedTable.getSelectedData();
            for (Object eqMod : data) {
                if (!(eqMod instanceof EquipModFacade)) continue;
                EquipCustomPanel.this.builder.removeModFromEquipment((EquipModFacade)eqMod, EquipCustomPanel.this.currentHead);
            }
            EquipCustomPanel.this.equipInfoHandler.refreshInfo();
            EquipCustomPanel.this.availableTable.refilter();
        }
    }

    private class AddEqmodAction
    extends AbstractAction {
        public AddEqmodAction() {
            super(LanguageBundle.getString("in_eqCust_AddPrimary"));
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = EquipCustomPanel.this.availableTable.getSelectedData();
            for (Object eqMod : data) {
                if (!(eqMod instanceof EquipModFacade)) continue;
                EquipCustomPanel.this.builder.addModToEquipment((EquipModFacade)eqMod, EquipCustomPanel.this.currentHead);
            }
            EquipCustomPanel.this.equipInfoHandler.refreshInfo();
            EquipCustomPanel.this.availableTable.refilter();
        }
    }

    private class EquipModInfoHandler
    implements ListSelectionListener {
        private CharacterFacade character;
        private EquipmentBuilderFacade builder;
        private EquipModFacade currObj;

        public EquipModInfoHandler(CharacterFacade character, EquipmentBuilderFacade builder) {
            this.character = character;
            this.builder = builder;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                Object obj = null;
                if (e.getSource() == EquipCustomPanel.this.availableTable.getSelectionModel()) {
                    int selectedRow = EquipCustomPanel.this.availableTable.getSelectedRow();
                    if (selectedRow != -1) {
                        obj = EquipCustomPanel.this.availableTable.getModel().getValueAt(selectedRow, 0);
                    }
                } else {
                    int selectedRow = EquipCustomPanel.this.selectedTable.getSelectedRow();
                    if (selectedRow != -1) {
                        obj = EquipCustomPanel.this.selectedTable.getModel().getValueAt(selectedRow, 0);
                    }
                }
                if (obj instanceof EquipModFacade && obj != this.currObj) {
                    this.currObj = (EquipModFacade)obj;
                    EquipCustomPanel.this.equipModInfoPane.setText(this.character.getInfoFactory().getHTMLInfo((EquipModFacade)obj, this.builder.getEquipment()));
                }
            }
        }
    }

    private class EquipInfoHandler
    implements ListSelectionListener {
        private CharacterFacade character;
        private EquipmentBuilderFacade builder2;

        public EquipInfoHandler(CharacterFacade character, EquipmentBuilderFacade builder) {
            this.character = character;
            this.builder2 = builder;
            this.refreshInfo();
        }

        private void refreshInfo() {
            EquipmentFacade equip = this.builder2.getEquipment();
            EquipCustomPanel.this.equipInfoPane.setText(this.character.getInfoFactory().getHTMLInfo(equip));
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                this.refreshInfo();
            }
        }
    }
}

