/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tools;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.Utilities;
import pcgen.gui2.util.event.PopupMouseAdapter;
import pcgen.system.LanguageBundle;
import pcgen.system.PropertyContext;

public class FlippingSplitPane
extends JSplitPane {
    private static final String DIVIDER_LOC_PREF_KEY = "location";
    private static final long serialVersionUID = 735390251967305647L;
    private final LockAction lockAction = new LockAction();
    private JPopupMenu popupMenu = null;
    private PropertyContext baseContext;
    private final String prefsKey;

    public FlippingSplitPane(String prefsKey) {
        this.prefsKey = prefsKey;
        this.initComponent();
    }

    public FlippingSplitPane(int newOrientation, String prefsKey) {
        super(newOrientation);
        this.prefsKey = prefsKey;
        this.initComponent();
    }

    public FlippingSplitPane(int newOrientation, boolean newContinuousLayout, String prefsKey) {
        super(newOrientation, newContinuousLayout);
        this.prefsKey = prefsKey;
        this.initComponent();
    }

    public FlippingSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent, String prefsKey) {
        super(newOrientation, newLeftComponent, newRightComponent);
        this.prefsKey = prefsKey;
        this.initComponent();
    }

    public FlippingSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent, String prefsKey) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
        this.prefsKey = prefsKey;
        this.initComponent();
    }

    @Override
    public void setContinuousLayout(boolean newContinuousLayout) {
        if (newContinuousLayout == this.isContinuousLayout()) {
            return;
        }
        super.setContinuousLayout(newContinuousLayout);
        FlippingSplitPane.maybeSetContinuousLayoutComponent(this.getLeftComponent(), newContinuousLayout);
        FlippingSplitPane.maybeSetContinuousLayoutComponent(this.getRightComponent(), newContinuousLayout);
    }

    private void setInitialDividerLocation() {
        PropertyContext context = this.baseContext.createChildContext(this.prefsKey);
        int location = context.getInt(DIVIDER_LOC_PREF_KEY, -1);
        if (location >= 0) {
            this.setDividerLocation(location);
        }
    }

    @Override
    public void setDividerLocation(int location) {
        PropertyContext context = this.baseContext.createChildContext(this.prefsKey);
        context.setInt(DIVIDER_LOC_PREF_KEY, location);
        if (this.isLocked()) {
            super.setDividerLocation(this.getLastDividerLocation());
        } else {
            super.setDividerLocation(location);
        }
    }

    @Override
    public void setDividerSize(int newSize) {
        if (newSize == this.getDividerSize()) {
            return;
        }
        super.setDividerSize(newSize);
        FlippingSplitPane.maybeSetDividerSizeComponent(this.getLeftComponent(), newSize);
        FlippingSplitPane.maybeSetDividerSizeComponent(this.getRightComponent(), newSize);
    }

    @Override
    public void setOneTouchExpandable(boolean newOneTouchExpandable) {
        if (newOneTouchExpandable == this.isOneTouchExpandable()) {
            return;
        }
        super.setOneTouchExpandable(newOneTouchExpandable);
        FlippingSplitPane.maybeSetOneTouchExpandableComponent(this.getLeftComponent(), newOneTouchExpandable);
        FlippingSplitPane.maybeSetOneTouchExpandableComponent(this.getRightComponent(), newOneTouchExpandable);
    }

    @Override
    public void setOrientation(int newOrientation) {
        if (newOrientation == this.getOrientation()) {
            return;
        }
        super.setOrientation(newOrientation);
        int subOrientation = FlippingSplitPane.invertOrientation(newOrientation);
        FlippingSplitPane.maybeSetOrientationComponent(this.getLeftComponent(), subOrientation);
        FlippingSplitPane.maybeSetOrientationComponent(this.getRightComponent(), subOrientation);
    }

    @Override
    public void resetToPreferredSizes() {
        this.fixedResetToPreferredSizes();
        FlippingSplitPane.maybeResetToPreferredSizesComponent(this.getLeftComponent());
        FlippingSplitPane.maybeResetToPreferredSizesComponent(this.getRightComponent());
    }

    private static void maybeCenterDividerLocationsComponent(Component c) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).centerDividerLocations();
        }
    }

    private void centerDividerLocations() {
        this.setDividerLocation(0.5);
        FlippingSplitPane.maybeCenterDividerLocationsComponent(this.getLeftComponent());
        FlippingSplitPane.maybeCenterDividerLocationsComponent(this.getRightComponent());
    }

    private static void maybeResetToPreferredSizesComponent(Component c) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).resetToPreferredSizes();
        }
    }

    private void fixedResetToPreferredSizes() {
        this.setDividerLocation((this.getMinimumDividerLocation() + this.getMaximumDividerLocation()) / 2);
    }

    private static int invertOrientation(int orientation) {
        return orientation == 1 ? 0 : 1;
    }

    private static void maybeFlipComponent(Component c) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).flipOrientation();
        }
    }

    private void flipOrientation() {
        super.setOrientation(FlippingSplitPane.invertOrientation(this.getOrientation()));
        FlippingSplitPane.maybeFlipComponent(this.getLeftComponent());
        FlippingSplitPane.maybeFlipComponent(this.getRightComponent());
        this.resetToPreferredSizes();
    }

    private static void maybeSetDividerSizeComponent(Component c, int size) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).setDividerSize(size);
        }
    }

    private static void maybeSetContinuousLayoutComponent(Component c, boolean newContinuousLayout) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).setContinuousLayout(newContinuousLayout);
        }
    }

    private static void maybeSetOneTouchExpandableComponent(Component c, boolean newOneTouchExpandable) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).setOneTouchExpandable(newOneTouchExpandable);
        }
    }

    private static void maybeSetOrientationComponent(Component c, int newOrientation) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).setOrientation(newOrientation);
        }
    }

    private boolean isLocked() {
        return this.lockAction.isLocked();
    }

    private static void maybeSetLockedComponent(Component c, boolean locked) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).setLocked(locked);
        }
    }

    private void setLocked(boolean locked) {
        this.lockAction.setLocked(locked);
    }

    private void initComponent() {
        SplitPaneUI anUi = this.getUI();
        if (anUi instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)anUi).getDivider().addMouseListener(new PopupListener());
        }
        this.setResizeWeight(0.5);
        this.baseContext = UIPropertyContext.createContext("dividerPrefs");
        this.setInitialDividerLocation();
    }

    private class ResetMenuItem
    extends JMenuItem
    implements ActionListener {
        ResetMenuItem() {
            super(LanguageBundle.getString("in_reset"));
            this.setMnemonic(LanguageBundle.getMnemonic("in_mn_reset"));
            this.setIcon(Icons.Redo16.getImageIcon());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlippingSplitPane.this.resetToPreferredSizes();
        }
    }

    private class PopupListener
    extends PopupMouseAdapter {
        private PopupListener() {
        }

        @Override
        protected void maybeShowPopup(MouseEvent e) {
            if (Utilities.isRightMouseButton(e)) {
                this.showPopup(e);
            } else if (Utilities.isShiftLeftMouseButton(e) && !FlippingSplitPane.this.isLocked()) {
                FlippingSplitPane.this.flipOrientation();
            }
        }

        @Override
        public void showPopup(MouseEvent e) {
            JPopupMenu menu = null;
            if (!FlippingSplitPane.this.isLocked()) {
                if (FlippingSplitPane.this.popupMenu == null) {
                    FlippingSplitPane.this.popupMenu = new JPopupMenu();
                    FlippingSplitPane.this.popupMenu.add(new CenterMenuItem());
                    FlippingSplitPane.this.popupMenu.add(new FlipMenuItem());
                    FlippingSplitPane.this.popupMenu.add(new ResetMenuItem());
                    FlippingSplitPane.this.popupMenu.addSeparator();
                    FlippingSplitPane.this.popupMenu.add(new JMenuItem(FlippingSplitPane.this.lockAction));
                    FlippingSplitPane.this.popupMenu.addSeparator();
                    FlippingSplitPane.this.popupMenu.add(new OptionsMenu());
                }
                menu = FlippingSplitPane.this.popupMenu;
            } else {
                menu = new JPopupMenu();
                menu.add(new JMenuItem(FlippingSplitPane.this.lockAction));
            }
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private class OptionsMenu
    extends JMenu {
        OptionsMenu() {
            super(LanguageBundle.getString("in_options"));
            this.setMnemonic(LanguageBundle.getMnemonic("in_mn_options"));
            this.add(new OneTouchExpandableMenuItem());
            this.add(new ContinuousLayoutMenuItem());
        }
    }

    private class OneTouchExpandableMenuItem
    extends JCheckBoxMenuItem
    implements ActionListener {
        OneTouchExpandableMenuItem() {
            super(LanguageBundle.getString("in_oneTouchExp"));
            this.setMnemonic(LanguageBundle.getMnemonic("in_mn_oneTouchExp"));
            this.setSelected(FlippingSplitPane.this.isOneTouchExpandable());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlippingSplitPane.this.setOneTouchExpandable(!FlippingSplitPane.this.isOneTouchExpandable());
        }
    }

    private class FlipMenuItem
    extends JMenuItem
    implements ActionListener {
        FlipMenuItem() {
            super(LanguageBundle.getString("in_flip"));
            this.setMnemonic(LanguageBundle.getMnemonic("in_mn_flip"));
            this.setIcon(Icons.Refresh16.getImageIcon());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlippingSplitPane.this.flipOrientation();
        }
    }

    private class ContinuousLayoutMenuItem
    extends JCheckBoxMenuItem
    implements ActionListener {
        ContinuousLayoutMenuItem() {
            super(LanguageBundle.getString("in_smothRes"));
            this.setMnemonic(LanguageBundle.getMnemonic("in_mn_smothRes"));
            this.setSelected(FlippingSplitPane.this.isContinuousLayout());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlippingSplitPane.this.setContinuousLayout(!FlippingSplitPane.this.isContinuousLayout());
        }
    }

    private class CenterMenuItem
    extends JMenuItem
    implements ActionListener {
        CenterMenuItem() {
            super(LanguageBundle.getString("in_center"));
            this.setMnemonic(LanguageBundle.getMnemonic("in_mn_center"));
            this.setIcon(Icons.MediaStop16.getImageIcon());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlippingSplitPane.this.centerDividerLocations();
        }
    }

    private class LockAction
    extends AbstractAction {
        private boolean wasContinuousLayout = false;
        private boolean locked = false;

        public LockAction() {
            this.putValue("SmallIcon", Icons.Bookmarks16.getImageIcon());
            this.configureProps();
        }

        private void configureProps() {
            String prop = this.locked ? "unlock" : "lock";
            this.putValue("Name", LanguageBundle.getString("in_" + prop));
            this.putValue("MnemonicKey", LanguageBundle.getMnemonic("in_mn_" + prop));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setLocked(!this.locked);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            if (this.locked == locked) {
                return;
            }
            this.locked = locked;
            this.configureProps();
            if (locked) {
                this.wasContinuousLayout = FlippingSplitPane.this.isContinuousLayout();
                FlippingSplitPane.this.setContinuousLayout(true);
            } else {
                FlippingSplitPane.this.setContinuousLayout(this.wasContinuousLayout);
            }
            FlippingSplitPane.maybeSetLockedComponent(FlippingSplitPane.this.getLeftComponent(), locked);
            FlippingSplitPane.maybeSetLockedComponent(FlippingSplitPane.this.getRightComponent(), locked);
        }
    }
}

