/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogRecord;
import javax.swing.SwingUtilities;
import pcgen.gui2.PCGenStatusBar;
import pcgen.gui2.util.SwingWorker;
import pcgen.system.PCGenTask;
import pcgen.system.PCGenTaskEvent;
import pcgen.system.PCGenTaskListener;
import pcgen.util.Logging;

public class StatusWorker
extends SwingWorker<List<LogRecord>>
implements PCGenTaskListener {
    private final String statusMsg;
    private final PCGenTask task;
    private final PCGenStatusBar statusBar;
    private boolean dirty = false;
    private List<LogRecord> errors = new ArrayList<LogRecord>();

    public StatusWorker(String statusMsg, PCGenTask task, PCGenStatusBar statusBar) {
        this.statusMsg = statusMsg;
        this.task = task;
        this.statusBar = statusBar;
    }

    @Override
    public List<LogRecord> construct() {
        final String oldMessage = this.statusBar.getContextMessage();
        this.statusBar.startShowingProgress(this.statusMsg, false);
        this.statusBar.getProgressBar().getModel().setRangeProperties(this.task.getProgress(), 1, 0, this.task.getMaximum(), true);
        this.task.addPCGenTaskListener(this);
        try {
            this.task.execute();
        }
        catch (Exception e) {
            Logging.errorPrint(e.getLocalizedMessage(), e);
        }
        this.task.removePCGenTaskListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusWorker.this.statusBar.setContextMessage(oldMessage);
            }
        });
        return this.errors;
    }

    @Override
    public void finished() {
        this.statusBar.endShowingProgress();
        super.finished();
    }

    @Override
    public void progressChanged(PCGenTaskEvent event) {
        if (!this.dirty) {
            this.dirty = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusWorker.this.statusBar.getProgressBar().getModel().setRangeProperties(StatusWorker.this.task.getProgress(), 1, 0, StatusWorker.this.task.getMaximum(), true);
                    StatusWorker.this.statusBar.getProgressBar().setString(StatusWorker.this.task.getMessage());
                    StatusWorker.this.dirty = false;
                }
            });
        }
    }

    @Override
    public void errorOccurred(PCGenTaskEvent event) {
        this.errors.add(event.getErrorRecord());
    }

    public List<LogRecord> getErrors() {
        return this.errors;
    }
}

