/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.AgeSet;
import pcgen.core.BioSet;
import pcgen.core.GameMode;
import pcgen.core.Kit;
import pcgen.core.PObject;
import pcgen.core.SystemCollections;
import pcgen.core.bonus.BonusObj;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public final class BioSetLoader
extends LstLineFileLoader {
    private static String regionName = "None";
    BioSet bioSet = new BioSet();
    int currentAgeSetIndex = 0;

    public static void clear() {
        regionName = "None";
    }

    @Override
    public void loadLstFile(LoadContext context, URI fileName) throws PersistenceLayerException {
        this.currentAgeSetIndex = 0;
        GameMode game = SystemCollections.getGameModeNamed(this.gameMode);
        this.bioSet = game.getBioSet();
        super.loadLstFile(context, fileName);
        game.setBioSet(this.bioSet);
    }

    @Override
    public void parseLine(LoadContext context, String lstLine, URI sourceURI) {
        if (lstLine.startsWith("AGESET:")) {
            String line = lstLine.substring(7);
            int pipeLoc = line.indexOf(124);
            if (pipeLoc == -1) {
                Logging.errorPrint("Found invalid AGESET in Bio Settings " + sourceURI + ", was expecting a |: " + lstLine);
                return;
            }
            String ageIndexString = line.substring(0, pipeLoc);
            try {
                this.currentAgeSetIndex = Integer.parseInt(ageIndexString);
                StringTokenizer colToken = new StringTokenizer(line.substring(pipeLoc + 1), "\t");
                AgeSet ageSet = new AgeSet(colToken.nextToken().intern(), this.currentAgeSetIndex);
                while (colToken.hasMoreTokens()) {
                    this.parseTokens(context, ageSet, colToken);
                }
                Integer oldIndex = this.bioSet.addToNameMap(ageSet = this.bioSet.addToAgeMap(regionName, ageSet, sourceURI));
                if (oldIndex != null && oldIndex != this.currentAgeSetIndex) {
                    Logging.errorPrint("Incompatible Index for AGESET in Bio Settings " + sourceURI + ": " + oldIndex + " and " + this.currentAgeSetIndex + " for " + ageSet.getName());
                }
            }
            catch (NumberFormatException e) {
                Logging.errorPrint("Illegal Index for AGESET in Bio Settings " + sourceURI + ": " + ageIndexString + " was not an integer");
            }
        } else {
            StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
            String raceName = "";
            ArrayList<String> preReqList = null;
            while (colToken.hasMoreTokens()) {
                String colString = colToken.nextToken();
                if (colString.startsWith("RACENAME:")) {
                    raceName = colString.substring(9);
                    continue;
                }
                if (colString.startsWith("REGION:")) {
                    regionName = colString.substring(7).intern();
                    continue;
                }
                if (PreParserFactory.isPreReqString(colString)) {
                    if (preReqList == null) {
                        preReqList = new ArrayList<String>();
                    }
                    preReqList.add(colString);
                    continue;
                }
                String aString = colString;
                if (preReqList != null) {
                    StringBuilder sBuf = new StringBuilder(100 + colString.length());
                    sBuf.append(colString);
                    int x = preReqList.size();
                    for (int i = 0; i < x; ++i) {
                        sBuf.append('[').append((String)preReqList.get(i)).append(']');
                    }
                    aString = sBuf.toString();
                }
                this.bioSet.addToUserMap(regionName, raceName.intern(), aString.intern(), this.currentAgeSetIndex);
            }
        }
    }

    private void parseTokens(LoadContext context, AgeSet ageSet, StringTokenizer tok) {
        PObject dummy = new PObject();
        try {
            List<TransitionChoice<Kit>> kits;
            while (tok.hasMoreTokens()) {
                String currentTok = tok.nextToken();
                if (currentTok.startsWith("BONUS:")) {
                    if (context.processToken(dummy, "BONUS", new String(currentTok.substring(6)))) {
                        context.commit();
                        continue;
                    }
                    context.rollback();
                    Logging.errorPrint("Error in BONUS parse: " + currentTok);
                    Logging.replayParsedMessages();
                    continue;
                }
                if (currentTok.startsWith("KIT:")) {
                    if (context.processToken(dummy, "KIT", new String(currentTok.substring(4)))) {
                        context.commit();
                        continue;
                    }
                    context.rollback();
                    Logging.errorPrint("Error in KIT parse: " + currentTok);
                    Logging.replayParsedMessages();
                    continue;
                }
                Logging.errorPrint("Unexpected token in AGESET: " + currentTok);
            }
            List<BonusObj> bonuses = dummy.getListFor(ListKey.BONUS);
            if (bonuses != null) {
                ageSet.addBonuses(bonuses);
            }
            if ((kits = dummy.getListFor(ListKey.KIT_CHOICE)) != null) {
                ageSet.addKits(kits);
            }
        }
        catch (PersistenceLayerException e) {
            Logging.errorPrint("Error in token parse: " + e.getLocalizedMessage());
        }
    }
}

