/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.StringTokenizer;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Kit;
import pcgen.core.kit.KitAbilities;
import pcgen.core.kit.KitAlignment;
import pcgen.core.kit.KitBio;
import pcgen.core.kit.KitClass;
import pcgen.core.kit.KitDeity;
import pcgen.core.kit.KitFunds;
import pcgen.core.kit.KitGear;
import pcgen.core.kit.KitKit;
import pcgen.core.kit.KitLangBonus;
import pcgen.core.kit.KitLevelAbility;
import pcgen.core.kit.KitProf;
import pcgen.core.kit.KitRace;
import pcgen.core.kit.KitSelect;
import pcgen.core.kit.KitSkill;
import pcgen.core.kit.KitSpells;
import pcgen.core.kit.KitStat;
import pcgen.core.kit.KitTable;
import pcgen.core.kit.KitTemplate;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.SourceEntry;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.CDOMKitLoader;
import pcgen.rules.persistence.CDOMSubLineLoader;
import pcgen.util.Logging;

public final class KitLoader
extends LstObjectFileLoader<Kit> {
    private final CDOMKitLoader kitLoader = new CDOMKitLoader();

    public KitLoader() {
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitAlignment>("ALIGN", KitAlignment.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitRace>("RACE", KitRace.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitSkill>("SKILL", KitSkill.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitGear>("GEAR", KitGear.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitSpells>("SPELLS", KitSpells.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitStat>("STAT", KitStat.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitProf>("PROF", KitProf.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitAbilities>("FEAT", KitAbilities.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitAbilities>("ABILITY", KitAbilities.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitBio>("NAME", KitBio.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitLevelAbility>("LEVELABILITY", KitLevelAbility.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitClass>("CLASS", KitClass.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitTemplate>("TEMPLATE", KitTemplate.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitDeity>("DEITY", KitDeity.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitKit>("KIT", KitKit.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitTable>("TABLE", KitTable.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitSelect>("SELECT", KitSelect.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitBio>("GENDER", KitBio.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitFunds>("FUNDS", KitFunds.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitLangBonus>("LANGBONUS", KitLangBonus.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitBio>("AGE", KitBio.class));
    }

    @Override
    protected Kit getObjectKeyed(LoadContext context, String aKey) {
        return context.getReferenceContext().silentlyGetConstructedCDOMObject(Kit.class, aKey);
    }

    @Override
    public Kit parseLine(LoadContext context, Kit target, String inputLine, SourceEntry source) throws PersistenceLayerException {
        if (inputLine.startsWith("STARTPACK:")) {
            if (target != null) {
                this.completeObject(context, source, target);
            }
            StringTokenizer st = new StringTokenizer(inputLine, "\t");
            String firstToken = st.nextToken();
            int colonLoc = firstToken.indexOf(58);
            target = context.getReferenceContext().constructCDOMObject(Kit.class, firstToken.substring(colonLoc + 1).intern());
            target.put(ObjectKey.SOURCE_CAMPAIGN, source.getCampaign());
            target.setSourceURI(source.getURI());
            context.addStatefulInformation(target);
            while (st.hasMoreTokens()) {
                String value;
                String token = st.nextToken().trim();
                int cLoc = token.indexOf(58);
                if (cLoc == -1) {
                    Logging.errorPrint("Invalid Token - does not contain a colon: '" + token + "' on line :" + inputLine + " in " + source.getURI());
                    continue;
                }
                if (cLoc == 0) {
                    Logging.errorPrint("Invalid Token - starts with a colon: '" + token + "' on line :" + inputLine + " in " + source.getURI());
                    continue;
                }
                String key = token.substring(0, cLoc);
                String string = value = cLoc == token.length() - 1 ? null : token.substring(cLoc + 1);
                if (context.processToken(target, key.intern(), value.intern())) {
                    context.commit();
                    continue;
                }
                context.rollback();
                Logging.replayParsedMessages();
            }
        } else if (inputLine.startsWith("REGION:")) {
            String value = inputLine.substring(7);
            context.clearStatefulInformation();
            if (value != null && value.length() > 0) {
                StringTokenizer st = new StringTokenizer(value, "\t");
                String region = st.nextToken();
                if (!region.equalsIgnoreCase("NONE")) {
                    if (context.addStatefulToken("PREREGION:" + region.intern())) {
                        context.commit();
                    } else {
                        context.rollback();
                        Logging.errorPrint("Invalid Stateful Token from Region NONE: PREREGION:'" + region + "' on line :" + inputLine + " in " + source.getURI());
                        Logging.replayParsedMessages();
                    }
                    Logging.clearParseMessages();
                }
                while (st.hasMoreTokens()) {
                    String gt = st.nextToken();
                    if (context.addStatefulToken(gt.intern())) continue;
                    Logging.errorPrint("Invalid Stateful Token: '" + gt + "' on line :" + inputLine + " in " + source.getURI());
                }
            }
        } else {
            context.rollback();
            if (this.kitLoader.parseSubLine(context, target, inputLine, source.getURI())) {
                Logging.clearParseMessages();
                context.commit();
            } else {
                context.rollback();
                Logging.replayParsedMessages();
                Logging.clearParseMessages();
            }
        }
        return target;
    }
}

