/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import pcgen.util.AbstractCollectionMap;
import pcgen.util.AbstractListMap;
import pcgen.util.CollectionMap;
import pcgen.util.ListMap;

public final class CollectionMaps {
    private CollectionMaps() {
    }

    private static <T> T createInstance(Class<T> c) {
        try {
            return c.newInstance();
        }
        catch (Exception ex) {
            Logger.getLogger(c.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static <K, V, C extends Collection<V>> CollectionMap<K, V, C> createCollectionMap(Class<? extends Map> mapClass, Class<C> collectionClass) {
        try {
            return new BasicCollectionMap(mapClass, collectionClass);
        }
        catch (Exception ex) {
            Logger.getLogger(CollectionMaps.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static <K, V, C extends List<V>> ListMap<K, V, C> createListMap(Class<? extends Map> mapClass, Class<C> listClass) {
        try {
            return new BasicListMap(mapClass, listClass);
        }
        catch (Exception ex) {
            Logger.getLogger(CollectionMaps.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static final class BasicCollectionMap<K, V, C extends Collection<V>>
    extends AbstractCollectionMap<K, V, C> {
        private final Map<K, C> map;
        private final Class<C> collectionClass;

        public BasicCollectionMap(Class<? extends Map> mapClass, Class<C> collectionClass) throws InstantiationException, IllegalAccessException {
            this.map = mapClass.newInstance();
            this.collectionClass = collectionClass;
        }

        @Override
        public boolean add(K key, V value) {
            Object collection = this.get(key);
            if (collection == null) {
                collection = (Collection)CollectionMaps.createInstance(this.collectionClass);
                if (collection.add(value)) {
                    this.put(key, (C)collection);
                    return true;
                }
                return false;
            }
            return collection.add(value);
        }

        @Override
        public boolean addAll(K key, Collection<? extends V> values) {
            Object collection = this.get(key);
            if (collection == null) {
                collection = (Collection)CollectionMaps.createInstance(this.collectionClass);
                if (collection.addAll(values)) {
                    this.put(key, (C)collection);
                    return true;
                }
                return false;
            }
            return collection.addAll(values);
        }

        @Override
        public C get(Object key) {
            return (C)((Collection)this.map.get(key));
        }

        @Override
        public C put(K key, C value) {
            if (value == null) {
                return (C)this.remove(key);
            }
            return (C)((Collection)this.map.put(key, value));
        }

        @Override
        public Set<Map.Entry<K, C>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public Set<K> keySet() {
            return this.map.keySet();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public C remove(Object key) {
            return (C)((Collection)this.map.remove(key));
        }

        @Override
        public boolean remove(Object key, Object value) {
            Object collection = this.get(key);
            if (collection != null && collection.remove(value)) {
                if (collection.isEmpty()) {
                    this.remove(key);
                }
                return true;
            }
            return false;
        }
    }

    private static final class BasicListMap<K, V, C extends List<V>>
    extends AbstractListMap<K, V, C> {
        private final Map<K, C> map;
        private final Class<C> collectionClass;

        public BasicListMap(Class<? extends Map> mapClass, Class<C> collectionClass) throws InstantiationException, IllegalAccessException {
            this.map = mapClass.newInstance();
            this.collectionClass = collectionClass;
        }

        @Override
        public void add(K key, int index, V value) {
            Object list = this.get(key);
            if (list == null) {
                list = (List)CollectionMaps.createInstance(this.collectionClass);
                list.add(index, value);
                this.put(key, (C)list);
            } else {
                list.add(index, value);
            }
        }

        @Override
        public boolean addAll(K key, Collection<? extends V> values) {
            Object collection = this.get(key);
            if (collection == null) {
                collection = (List)CollectionMaps.createInstance(this.collectionClass);
                if (collection.addAll(values)) {
                    this.put(key, (C)collection);
                    return true;
                }
                return false;
            }
            return collection.addAll(values);
        }

        @Override
        public C get(Object key) {
            return (C)((List)this.map.get(key));
        }

        @Override
        public C put(K key, C value) {
            if (value == null) {
                return (C)this.remove(key);
            }
            return (C)((List)this.map.put(key, value));
        }

        @Override
        public Set<Map.Entry<K, C>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public Set<K> keySet() {
            return this.map.keySet();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public C remove(Object key) {
            return (C)((List)this.map.remove(key));
        }

        @Override
        public V remove(Object key, int index) {
            Object list = this.get(key);
            if (list != null) {
                Object value = list.remove(index);
                if (list.isEmpty()) {
                    this.remove(key);
                }
                return (V)value;
            }
            return null;
        }
    }
}

