/*
 * Decompiled with CFR 0.152.
 */
package plugin.converter;

import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.SubClassCategory;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CategorizedCDOMReference;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.Race;
import pcgen.core.SubClass;
import pcgen.gui2.converter.event.TokenProcessEvent;
import pcgen.gui2.converter.event.TokenProcessorPlugin;
import pcgen.rules.context.EditorLoadContext;
import pcgen.rules.persistence.token.AbstractToken;

public class FavClassConvertPlugin
extends AbstractToken
implements TokenProcessorPlugin {
    public static final Class<PCClass> PCCLASS_CLASS = PCClass.class;
    public static final Class<SubClass> SUBCLASS_CLASS = SubClass.class;

    @Override
    public String process(TokenProcessEvent tpe) {
        String value = tpe.getValue();
        if (!value.startsWith("CHOOSE:")) {
            return null;
        }
        String choices = value.substring(7);
        if (this.isEmpty(choices) || this.hasIllegalSeparator('|', choices)) {
            return "Empty Token";
        }
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(choices, "|");
        ArrayList<CDOMGroupRef<PCClass>> refList = new ArrayList<CDOMGroupRef<PCClass>>();
        EditorLoadContext context = tpe.getContext();
        while (tok.hasMoreTokens()) {
            CDOMReference ref;
            String token = tok.nextToken();
            if ("ALL".equalsIgnoreCase(token) || "ANY".equalsIgnoreCase(token)) {
                foundAny = true;
                ref = context.getReferenceContext().getCDOMAllReference(PCCLASS_CLASS);
            } else {
                foundOther = true;
                int dotLoc = token.indexOf(46);
                if (dotLoc == -1) {
                    ref = context.getReferenceContext().getCDOMReference(PCCLASS_CLASS, token);
                } else {
                    String parent = token.substring(0, dotLoc);
                    String subclass = token.substring(dotLoc + 1);
                    SubClassCategory scc = SubClassCategory.getConstant(parent);
                    ref = context.getReferenceContext().getCDOMReference(SUBCLASS_CLASS, scc, subclass);
                }
            }
            refList.add((CDOMGroupRef<PCClass>)ref);
        }
        if (foundAny && foundOther) {
            return "Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value;
        }
        String name = tpe.getPrimary().get(StringKey.CONVERT_NAME);
        String templName = "Race " + name + " Favored Class";
        tpe.append("TEMPLATE:");
        tpe.append(templName);
        PCTemplate templ = new PCTemplate();
        context.unconditionallyProcess(templ, "FAVOREDCLASS", "%LIST");
        StringBuilder chooseValue = new StringBuilder();
        chooseValue.append("CLASS|");
        boolean first = true;
        for (CDOMReference cDOMReference : refList) {
            if (!first) {
                chooseValue.append(",");
            }
            first = false;
            Class refClass = cDOMReference.getReferenceClass();
            if (SUBCLASS_CLASS.equals(refClass)) {
                Category parent = ((CategorizedCDOMReference)((Object)cDOMReference)).getCDOMCategory();
                chooseValue.append(parent.toString());
                chooseValue.append(".");
            }
            chooseValue.append(cDOMReference.getLSTformat(false));
        }
        context.unconditionallyProcess(templ, "CHOOSE", chooseValue.toString());
        templ.setName(templName);
        tpe.inject(templ);
        tpe.consume();
        return null;
    }

    @Override
    public Class<? extends CDOMObject> getProcessedClass() {
        return Race.class;
    }

    @Override
    public String getProcessedToken() {
        return "FAVCLASS";
    }

    @Override
    public String getTokenName() {
        return this.getProcessedToken();
    }
}

