/*
 * Decompiled with CFR 0.152.
 */
package plugin.experience.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import pcgen.core.SettingsHandler;
import pcgen.gui2.dialog.AbstractDialog;
import plugin.experience.DefeatedCombatant;
import plugin.experience.ExperienceAdjusterModel;
import plugin.experience.ExperienceListItem;

public class AddDefeatedCombatant
extends AbstractDialog {
    private static final String OPTION_NAME_DBMAXNUM = "Experience_Adjuster.dbMaxNum";
    public ExperienceAdjusterModel model;
    private JLabel lCR;
    private JLabel lCR2;
    private JLabel lName;
    private JLabel lNumber;
    private SpinnerNumberModel sNumber;
    private JTextField tCR;
    private JTextField tName;
    private JSpinner tNumber;

    public AddDefeatedCombatant(Frame parent, boolean modal, ExperienceAdjusterModel model) {
        super(parent, "Add defeated combatant", modal);
        this.pack();
        this.setLocation(parent.getX() + 100, parent.getY() + 100);
        this.model = model;
        this.sNumber.setMinimum(Integer.valueOf(1));
        int maxNum = SettingsHandler.getGMGenOption(OPTION_NAME_DBMAXNUM, 20);
        this.sNumber.setMaximum(Integer.valueOf(maxNum));
    }

    @Override
    public void applyButtonActionPerformed() {
        for (int i = 1; i <= this.sNumber.getNumber().intValue(); ++i) {
            String enemyName = this.tName.getText().isEmpty() ? "Defeated Enemy" : this.tName.getText();
            if (this.sNumber.getNumber().intValue() > 1) {
                enemyName = MessageFormat.format("{0} ({1})", enemyName, i);
            }
            this.model.addEnemy(new ExperienceListItem(new DefeatedCombatant(enemyName, this.checkCRField(this.tCR, 0.0f))));
        }
    }

    private float checkCRField(JTextField tf, float def) {
        try {
            float value = Float.parseFloat(tf.getText());
            if ((double)value > 1.0) {
                value = (int)value / 1;
            }
            return value;
        }
        catch (NumberFormatException e) {
            tf.setText(Float.toString(def));
            return def;
        }
    }

    @Override
    protected JComponent getCenter() {
        JPanel panel = new JPanel();
        this.lName = new JLabel();
        this.tName = new JTextField();
        this.lNumber = new JLabel();
        this.sNumber = new SpinnerNumberModel(1, 1, 20, 1);
        this.tNumber = new JSpinner(this.sNumber);
        this.lCR = new JLabel();
        this.lCR2 = new JLabel();
        this.tCR = new JTextField();
        panel.setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AddDefeatedCombatant.this.close();
            }
        });
        this.lCR.setText("CR: ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        panel.add((Component)this.lCR, gridBagConstraints);
        this.lNumber.setText("Number: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        panel.add((Component)this.lNumber, gridBagConstraints);
        this.lName.setText("Name: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        gridBagConstraints.anchor = 21;
        panel.add((Component)this.lName, gridBagConstraints);
        this.lCR2.setText("(Note, use decimal fractions for CR. Ex: .5 = 1/2)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        gridBagConstraints.anchor = 21;
        panel.add((Component)this.lCR2, gridBagConstraints);
        this.tCR.setText("1.0");
        this.tCR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddDefeatedCombatant.this.tCRActionPerformed(evt);
            }
        });
        this.tCR.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AddDefeatedCombatant.this.tCRFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.tCR.setColumns(5);
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        gridBagConstraints.anchor = 21;
        panel.add((Component)this.tCR, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        gridBagConstraints.anchor = 21;
        panel.add((Component)this.tNumber, gridBagConstraints);
        this.tName.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        panel.add((Component)this.tName, gridBagConstraints);
        return panel;
    }

    private void tCRActionPerformed(ActionEvent evt) {
        this.tCR.setText(Float.toString(this.checkCRField(this.tCR, 1.0f)));
    }

    private void tCRFocusLost(FocusEvent evt) {
        this.tCR.setText(Float.toString(this.checkCRField(this.tCR, 1.0f)));
    }

    @Override
    protected String getOkMnKey() {
        return "in_mn_add";
    }

    @Override
    protected String getOkKey() {
        return "in_add";
    }
}

