/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.deprecated;

import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Domain;
import pcgen.core.QualifiedObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.lst.DeprecatedToken;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMCompatibilityToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class ClassLevelDomainBracketToken
extends AbstractTokenWithSeparator<PCClassLevel>
implements CDOMCompatibilityToken<PCClassLevel>,
DeprecatedToken {
    private static final Class<Domain> DOMAIN_CLASS = Domain.class;

    @Override
    public String getTokenName() {
        return "DOMAIN";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClassLevel level, String value) {
        Logging.deprecationPrint(this.getMessage(level, value));
        StringTokenizer pipeTok = new StringTokenizer(value, "|");
        boolean first = true;
        while (pipeTok.hasMoreTokens()) {
            String domainKey;
            String tok = pipeTok.nextToken();
            if (".CLEAR".equals(tok)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item", context);
                }
                context.getObjectContext().removeList(level, ListKey.DOMAIN);
                continue;
            }
            Prerequisite prereq = null;
            int openBracketLoc = tok.indexOf(91);
            if (openBracketLoc == -1) {
                if (tok.indexOf(93) != -1) {
                    return new ParseResult.Fail("Invalid " + this.getTokenName() + " must have '[' if it contains a PREREQ tag", context);
                }
                domainKey = tok;
            } else {
                if (tok.lastIndexOf(93) != tok.length() - 1) {
                    return new ParseResult.Fail("Invalid " + this.getTokenName() + " must end with ']' if it contains a PREREQ tag", context);
                }
                domainKey = tok.substring(0, openBracketLoc);
                String prereqString = tok.substring(openBracketLoc + 1, tok.length() - 1);
                if (prereqString.length() == 0) {
                    return new ParseResult.Fail(this.getTokenName() + " cannot have empty prerequisite : " + value, context);
                }
                prereq = this.getPrerequisite(prereqString);
                if (prereq == null) {
                    return new ParseResult.Fail(this.getTokenName() + " had invalid prerequisite : " + prereqString, context);
                }
            }
            CDOMSingleRef<Domain> domain = context.getReferenceContext().getCDOMReference(DOMAIN_CLASS, domainKey);
            QualifiedObject<CDOMSingleRef<Domain>> qo = new QualifiedObject<CDOMSingleRef<Domain>>(domain);
            if (prereq != null) {
                qo.addPrerequisite(prereq);
            }
            context.getObjectContext().addToList(level, ListKey.DOMAIN, qo);
            first = false;
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public Class<PCClassLevel> getTokenClass() {
        return PCClassLevel.class;
    }

    @Override
    public int compatibilityLevel() {
        return 6;
    }

    @Override
    public int compatibilitySubLevel() {
        return 2;
    }

    @Override
    public int compatibilityPriority() {
        return 0;
    }

    @Override
    public String getMessage(CDOMObject obj, String value) {
        return "Found deprecated DOMAIN: token on " + obj.getClass().getSimpleName() + ": " + obj.getKeyName() + " -- " + value;
    }
}

