/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class CtToken
implements CDOMPrimaryToken<Spell> {
    @Override
    public String getTokenName() {
        return "CT";
    }

    @Override
    public String[] unparse(LoadContext context, Spell spell) {
        Integer i = context.getObjectContext().getInteger(spell, IntegerKey.CASTING_THRESHOLD);
        if (i == null) {
            return null;
        }
        if (i < 0) {
            context.addWriteMessage(this.getTokenName() + " requires a positive Integer");
            return null;
        }
        return new String[]{i.toString()};
    }

    @Override
    public Class<Spell> getTokenClass() {
        return Spell.class;
    }

    @Override
    public ParseResult parseToken(LoadContext context, Spell spell, String value) {
        try {
            Integer ct = Integer.valueOf(value);
            if (ct < 0) {
                return new ParseResult.Fail(this.getTokenName() + " requires a positive Integer", context);
            }
            context.getObjectContext().put((CDOMObject)spell, IntegerKey.CASTING_THRESHOLD, ct);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>", context);
        }
    }
}

