/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.parser;

import java.util.ArrayList;
import pcgen.cdom.enumeration.FactKey;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.output.publish.OutputDB;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteListParser;
import pcgen.rules.persistence.token.ParseResult;

public class PreFactParser
extends AbstractPrerequisiteListParser {
    @Override
    public String[] kindsHandled() {
        return new String[]{"fact"};
    }

    @Override
    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        if (prereq.isCountMultiples()) {
            throw new PersistenceLayerException("PREFACT does not support CHECKMULT");
        }
        prereq.setOverrideQualify(overrideQualify);
        return prereq;
    }

    @Override
    protected void parsePrereqListType(Prerequisite prereq, String kind, String formula) throws PersistenceLayerException {
        int i;
        ParseResult parseResult = this.checkForIllegalSeparator(kind, ',', formula);
        if (!parseResult.passed()) {
            throw new PersistenceLayerException(parseResult.toString());
        }
        if (formula.indexOf("[") >= 0 || formula.indexOf("]") >= 0) {
            throw new PersistenceLayerException("Prerequisite " + kind + " can not contain []: " + formula);
        }
        if (formula.indexOf("|") >= 0) {
            throw new PersistenceLayerException("Prerequisite " + kind + " can not contain |: " + formula);
        }
        String[] elements = formula.split(",");
        try {
            Integer.parseInt(elements[0]);
            if (elements.length == 1) {
                throw new PersistenceLayerException("Prerequisite " + kind + " can not have only a count: " + formula);
            }
        }
        catch (NumberFormatException nfe) {
            throw new PersistenceLayerException("'" + elements[0] + "' is not a valid integer");
        }
        String filetype = elements[1];
        String[] fileElements = filetype.split("\\.");
        if (!OutputDB.isLegal(fileElements[0])) {
            throw new PersistenceLayerException("'" + elements[1] + "' is not a valid location to check for a FACT");
        }
        for (i = 2; i < elements.length; ++i) {
            if (elements[i].indexOf(61) != -1) continue;
            throw new PersistenceLayerException("PREFACT require a target value, e.g. Key=Value, found: " + elements[i]);
        }
        prereq.setOperand(elements[0]);
        if (elements.length == 3) {
            this.checkFactKey(elements[2]);
            prereq.setKey(elements[2]);
        } else {
            prereq.setOperator(PrerequisiteOperator.GTEQ);
            prereq.setKind(null);
            for (i = 2; i < elements.length; ++i) {
                Prerequisite subreq = new Prerequisite();
                subreq.setKind(kind.toLowerCase());
                subreq.setCountMultiples(true);
                subreq.setOperator(PrerequisiteOperator.GTEQ);
                subreq.setCategoryName(filetype);
                this.checkFactKey(elements[i]);
                subreq.setKey(elements[i]);
                subreq.setOperand("1");
                prereq.addPrerequisite(subreq);
            }
        }
        this.setLocation(prereq, filetype);
    }

    private void checkFactKey(String factTest) throws PersistenceLayerException {
        String[] parts = factTest.split("=");
        try {
            FactKey.valueOf(parts[0]);
        }
        catch (IllegalArgumentException e) {
            throw new PersistenceLayerException("Unknown FACT in PREFACT. Test was: " + factTest);
        }
    }

    private void setLocation(Prerequisite prereq, String location) throws PersistenceLayerException {
        if (prereq.getPrerequisiteCount() == 0) {
            prereq.setCategoryName(location);
        }
        ArrayList<Prerequisite> prereqList = new ArrayList<Prerequisite>(prereq.getPrerequisites());
        for (Prerequisite p : prereqList) {
            if (p.getKind() == null) {
                this.setLocation(p, location);
                continue;
            }
            prereq.setCategoryName(location);
        }
    }

    @Override
    protected boolean requiresValue() {
        return true;
    }
}

