/*
 * Decompiled with CFR 0.152.
 */
package plugin.primitive.deity;

import java.util.Collection;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Deity;
import pcgen.core.PCAlignment;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.PrimitiveToken;

public class AlignToken
implements PrimitiveToken<Deity>,
PrimitiveFilter<Deity> {
    private static final Class<PCAlignment> ALIGNMENT_CLASS = PCAlignment.class;
    private static final Class<Deity> DEITY_CLASS = Deity.class;
    private CDOMSingleRef<PCAlignment> alignment;
    private CDOMReference<Deity> allDeities;

    @Override
    public boolean initialize(LoadContext context, Class<Deity> cl, String value, String args) {
        if (args != null) {
            return false;
        }
        this.alignment = context.getReferenceContext().getCDOMReference(ALIGNMENT_CLASS, value);
        this.allDeities = context.getReferenceContext().getCDOMAllReference(DEITY_CLASS);
        return this.alignment != null;
    }

    @Override
    public String getTokenName() {
        return "ALIGN";
    }

    @Override
    public Class<Deity> getReferenceClass() {
        return DEITY_CLASS;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return this.getTokenName() + "=" + this.alignment.getLSTformat(false);
    }

    @Override
    public boolean allow(PlayerCharacter pc, Deity deity) {
        CDOMSingleRef<PCAlignment> alignRef = deity.get(ObjectKey.ALIGNMENT);
        return alignRef != null && this.alignment.resolvesTo().equals(alignRef.resolvesTo());
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AlignToken) {
            AlignToken other = (AlignToken)obj;
            return this.alignment.equals(other.alignment);
        }
        return false;
    }

    public int hashCode() {
        return this.alignment == null ? -5 : this.alignment.hashCode();
    }

    @Override
    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<Deity, R> c) {
        return c.convert(this.allDeities, this);
    }
}

