/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Domain;
import pcgen.core.PCClass;
import pcgen.core.QualifiedObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class DomainToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass> {
    private static final Class<Domain> DOMAIN_CLASS = Domain.class;

    public String getTokenName() {
        return "DOMAIN";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass pcc, String value) {
        StringTokenizer pipeTok = new StringTokenizer(value, "|");
        boolean first = true;
        String tok = pipeTok.nextToken();
        if (this.looksLikeAPrerequisite(tok)) {
            return new ParseResult.Fail("Cannot have only PRExxx subtoken in " + this.getTokenName() + ": " + value, context);
        }
        ArrayList<QualifiedObject> toAdd = new ArrayList<QualifiedObject>();
        boolean foundClear = false;
        do {
            if (".CLEAR".equals(tok)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item", context);
                }
                context.getObjectContext().removeList((CDOMObject)pcc, ListKey.DOMAIN);
                foundClear = true;
            } else {
                CDOMSingleRef domain = context.getReferenceContext().getCDOMReference(DOMAIN_CLASS, tok);
                QualifiedObject qo = new QualifiedObject((Object)domain);
                toAdd.add(qo);
                context.getObjectContext().addToList((CDOMObject)pcc, ListKey.DOMAIN, (Object)qo);
            }
            first = false;
            if (pipeTok.hasMoreTokens()) continue;
            return ParseResult.SUCCESS;
        } while (!this.looksLikeAPrerequisite(tok = pipeTok.nextToken()));
        if (foundClear) {
            return new ParseResult.Fail("Cannot use PREREQs when using .CLEAR in " + this.getTokenName(), context);
        }
        while (true) {
            Prerequisite prereq;
            if ((prereq = this.getPrerequisite(tok)) == null) {
                return new ParseResult.Fail("   (Did you put feats after the PRExxx tags in " + this.getTokenName() + ":?)", context);
            }
            for (PrereqObject prereqObject : toAdd) {
                prereqObject.addPrerequisite(prereq);
            }
            if (!pipeTok.hasMoreTokens()) break;
            tok = pipeTok.nextToken();
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCClass pcc) {
        Collection removedItems;
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)pcc, ListKey.DOMAIN);
        ArrayList<String> returnList = new ArrayList<String>();
        if (changes.includesGlobalClear()) {
            returnList.add(".CLEAR");
        }
        if ((removedItems = changes.getRemoved()) != null && !removedItems.isEmpty()) {
            context.addWriteMessage(this.getTokenName() + " does not support .CLEAR.");
            return null;
        }
        Collection added = changes.getAdded();
        if (added != null && !added.isEmpty()) {
            HashMapToList m = new HashMapToList();
            for (QualifiedObject qo : added) {
                m.addToListFor((Object)qo.getPrerequisiteList(), qo.getRawObject());
            }
            TreeSet<String> returnSet = new TreeSet<String>();
            for (List prereqs : m.getKeySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append(ReferenceUtilities.joinLstFormat((Collection)m.getListFor((Object)prereqs), (String)"|"));
                if (prereqs != null && !prereqs.isEmpty()) {
                    sb.append("|");
                    sb.append(this.getPrerequisiteString(context, prereqs));
                }
                returnSet.add(sb.toString());
            }
            returnList.addAll(returnSet);
        }
        if (returnList.isEmpty()) {
            return null;
        }
        return returnList.toArray(new String[returnList.size()]);
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

