/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.subclass;

import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.SpellProhibitor;
import pcgen.core.SubClass;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.ProhibitedSpellType;

public class ChoiceToken
extends AbstractTokenWithSeparator<SubClass>
implements CDOMPrimaryToken<SubClass> {
    public String getTokenName() {
        return "CHOICE";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, SubClass sc, String value) {
        ProhibitedSpellType type;
        int pipeLoc = value.indexOf(124);
        if (pipeLoc == -1) {
            return new ParseResult.Fail(this.getTokenName() + " has no | separator for arguments: " + value, context);
        }
        if (value.lastIndexOf(124) != pipeLoc) {
            return new ParseResult.Fail(this.getTokenName() + " has more than two | separated arguments: " + value, context);
        }
        String pstString = value.substring(0, pipeLoc);
        try {
            type = ProhibitedSpellType.valueOf((String)pstString);
        }
        catch (IllegalArgumentException e) {
            ComplexParseResult cpr = new ComplexParseResult();
            cpr.addErrorMessage(this.getTokenName() + " encountered an invalid Prohibited Spell Type: " + value);
            cpr.addErrorMessage("  Legal values are: " + StringUtil.join(Arrays.asList(ProhibitedSpellType.values()), (String)", "));
            return cpr;
        }
        if (type.equals((Object)ProhibitedSpellType.SCHOOL) || type.equals((Object)ProhibitedSpellType.SUBSCHOOL) || type.equals((Object)ProhibitedSpellType.DESCRIPTOR)) {
            SpellProhibitor sp = new SpellProhibitor();
            sp.setType(type);
            sp.addValue(value.substring(pipeLoc + 1));
            context.getObjectContext().put((CDOMObject)sc, ObjectKey.CHOICE, (Object)sp);
            return ParseResult.SUCCESS;
        }
        return new ParseResult.Fail("Invalid TYPE in " + this.getTokenName() + ": " + pstString, context);
    }

    public String[] unparse(LoadContext context, SubClass pcc) {
        SpellProhibitor sp = (SpellProhibitor)context.getObjectContext().getObject((CDOMObject)pcc, ObjectKey.CHOICE);
        if (sp == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ProhibitedSpellType pst = sp.getType();
        sb.append(pst.toString().toUpperCase());
        sb.append('|');
        List valueSet = sp.getValueList();
        sb.append(StringUtil.join(new TreeSet(valueSet), (String)"|"));
        return new String[]{sb.toString()};
    }

    public Class<SubClass> getTokenClass() {
        return SubClass.class;
    }
}

