/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute.validate;

import guru.nidi.graphviz.attribute.validate.AttributeValidator;
import guru.nidi.graphviz.attribute.validate.Datatype;
import guru.nidi.graphviz.attribute.validate.ValidatorEngine;
import guru.nidi.graphviz.attribute.validate.ValidatorFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;

final class AttributeConfig {
    final EnumSet<AttributeValidator.Scope> scopes;
    final List<Datatype> types;
    @Nullable
    final Object defVal;
    @Nullable
    final Double min;
    @Nullable
    final Double max;
    final EnumSet<ValidatorEngine> engines;
    final EnumSet<ValidatorFormat> formats;

    private AttributeConfig(EnumSet<AttributeValidator.Scope> scopes, List<Datatype> types, @Nullable Object defVal, @Nullable Double min, @Nullable Double max, EnumSet<ValidatorEngine> engines, EnumSet<ValidatorFormat> formats) {
        this.scopes = scopes;
        this.types = types;
        this.defVal = defVal;
        this.min = min;
        this.max = max;
        this.engines = engines;
        this.formats = formats;
    }

    static AttributeConfig entry(String scopes, Datatype type) {
        return AttributeConfig.entry(scopes, type, null);
    }

    static AttributeConfig entry(String scopes, List<Datatype> types) {
        return AttributeConfig.entry(scopes, types, null);
    }

    static AttributeConfig entry(String scopes, Datatype type, @Nullable Object defVal) {
        return AttributeConfig.entry(scopes, type, defVal, null);
    }

    static AttributeConfig entry(String scopes, List<Datatype> types, @Nullable Object defVal) {
        return AttributeConfig.entry(scopes, types, defVal, null);
    }

    static AttributeConfig entry(String scopes, Datatype type, @Nullable Object defVal, @Nullable Double min) {
        return AttributeConfig.entry(scopes, Collections.singletonList(type), defVal, min);
    }

    static AttributeConfig entry(String scopes, Datatype type, @Nullable Object defVal, @Nullable Double min, @Nullable Double max) {
        return AttributeConfig.entry(scopes, Collections.singletonList(type), defVal, min, max);
    }

    static AttributeConfig entry(String scopes, List<Datatype> types, @Nullable Object defVal, @Nullable Double min) {
        return AttributeConfig.entry(scopes, types, defVal, min, null);
    }

    static AttributeConfig entry(String scopes, List<Datatype> types, @Nullable Object defVal, @Nullable Double min, @Nullable Double max) {
        return new AttributeConfig(AttributeConfig.scopesOf(scopes), types, defVal, min, max, EnumSet.noneOf(ValidatorEngine.class), EnumSet.noneOf(ValidatorFormat.class));
    }

    AttributeConfig engines(ValidatorEngine ... engines) {
        return new AttributeConfig(this.scopes, this.types, this.defVal, this.min, this.max, EnumSet.of(engines[0], engines), this.formats);
    }

    AttributeConfig formats(ValidatorFormat ... formats) {
        return new AttributeConfig(this.scopes, this.types, this.defVal, this.min, this.max, this.engines, EnumSet.of(formats[0], formats));
    }

    private static EnumSet<AttributeValidator.Scope> scopesOf(String scopes) {
        EnumSet<AttributeValidator.Scope> res = EnumSet.noneOf(AttributeValidator.Scope.class);
        block7: for (int i = 0; i < scopes.length(); ++i) {
            switch (scopes.charAt(i)) {
                case 'G': {
                    res.add(AttributeValidator.Scope.GRAPH);
                    continue block7;
                }
                case 'S': {
                    res.add(AttributeValidator.Scope.SUB_GRAPH);
                    continue block7;
                }
                case 'C': {
                    res.add(AttributeValidator.Scope.CLUSTER);
                    continue block7;
                }
                case 'N': {
                    res.add(AttributeValidator.Scope.NODE);
                    continue block7;
                }
                case 'E': {
                    res.add(AttributeValidator.Scope.EDGE);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("unknown scope '" + scopes.charAt(i) + "'.");
                }
            }
        }
        return res;
    }
}

