/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute.validate;

import guru.nidi.graphviz.attribute.Style;
import guru.nidi.graphviz.attribute.validate.Datatype;
import guru.nidi.graphviz.attribute.validate.ValidatorMessage;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class StyleDatatype
extends Datatype {
    private static final Set<String> STYLES = StyleDatatype.fieldNames(Style.class);

    StyleDatatype() {
        super("style");
    }

    @Override
    ValidatorMessage validate(Object value) {
        String[] styles = value.toString().split(",");
        String invalids = Stream.of(styles).filter(s -> !STYLES.contains(s.trim())).collect(Collectors.joining(", "));
        return invalids.isEmpty() ? null : new ValidatorMessage(ValidatorMessage.Severity.ERROR, "has the invalid " + this.name + " value(s) '" + invalids + "'.");
    }
}

