/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

final class TempFiles {
    private static final long TIME_TO_LIVE = 259200000L;
    private static final File TEMP_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + "GraphvizJava");

    private TempFiles() {
    }

    static Path tempDir(String name) throws IOException {
        return Files.createTempDirectory(TEMP_DIR.toPath(), name, new FileAttribute[0]);
    }

    private static void mkdir() {
        TEMP_DIR.mkdirs();
    }

    private static void cleanup() {
        File[] files2 = TEMP_DIR.listFiles();
        if (files2 != null) {
            for (File file : files2) {
                if (System.currentTimeMillis() - file.lastModified() <= 259200000L) continue;
                TempFiles.deleteDir(file);
            }
        }
    }

    private static void deleteDir(File f) {
        if (f.isFile()) {
            f.delete();
        } else if (f.isDirectory()) {
            File[] files2 = f.listFiles();
            if (files2 != null) {
                for (File file : files2) {
                    TempFiles.deleteDir(file);
                }
            }
            f.delete();
        }
    }

    static {
        TempFiles.mkdir();
        TempFiles.cleanup();
    }
}

