/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.environment;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import uk.org.webcompere.systemstubs.environment.EnvironmentVariableMocker;
import uk.org.webcompere.systemstubs.properties.PropertiesUtils;
import uk.org.webcompere.systemstubs.resource.NameValuePairSetter;
import uk.org.webcompere.systemstubs.resource.SingularTestResource;

public class EnvironmentVariables
extends SingularTestResource
implements NameValuePairSetter<EnvironmentVariables> {
    private final Map<String, String> variables;
    private final Set<String> toRemove = new HashSet<String>();

    public EnvironmentVariables() {
        this(Collections.emptyMap());
    }

    public EnvironmentVariables(String name, String value, String ... others) {
        if (others.length % 2 != 0) {
            throw new IllegalArgumentException("Must provide even number of parameters");
        }
        this.variables = new HashMap<String, String>();
        this.variables.put(name, value);
        for (int i = 0; i < others.length; i += 2) {
            this.variables.put(others[i], others[i + 1]);
        }
    }

    public EnvironmentVariables(Properties properties) {
        this(PropertiesUtils.toStringMap(properties));
    }

    public EnvironmentVariables(Map<String, String> variables) {
        this.variables = new HashMap<String, String>(variables);
    }

    public EnvironmentVariables and(String name, String value) {
        this.validateNotSet(name, value);
        return new EnvironmentVariables(this.variables).set(name, value);
    }

    @Override
    public EnvironmentVariables set(String name, String value) {
        this.variables.put(name, value);
        return this;
    }

    @Override
    public EnvironmentVariables remove(String name) {
        this.toRemove.add(name);
        this.variables.remove(name);
        return this;
    }

    public Map<String, String> getVariables() {
        return new HashMap<String, String>(this.variables);
    }

    private void validateNotSet(String name, String value) {
        if (this.variables.containsKey(name)) {
            String currentValue = this.variables.get(name);
            throw new IllegalArgumentException("The environment variable '" + name + "' cannot be set to " + this.format(value) + " because it was already set to " + this.format(currentValue) + ".");
        }
    }

    private String format(String text) {
        if (text == null) {
            return "null";
        }
        return "'" + text + "'";
    }

    @Override
    protected void doSetup() {
        EnvironmentVariableMocker.connect(this.variables, this.toRemove);
    }

    @Override
    protected void doTeardown() {
        EnvironmentVariableMocker.remove(this.variables);
    }
}

