/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.util;

import java.util.Iterator;
import java.util.LinkedList;
import jlibs.core.util.EmptyIterator;

public class StackedIterator<T>
implements Iterator<T> {
    private LinkedList<Iterator<T>> list = new LinkedList();
    private Iterator<T> current;

    public StackedIterator(Iterator<T> delegate) {
        this.list.addLast(delegate);
    }

    private Iterator<T> current() {
        while (!this.list.isEmpty()) {
            Iterator<T> current = this.list.getLast();
            if (current.hasNext()) {
                return current;
            }
            this.list.removeLast();
        }
        return EmptyIterator.instance();
    }

    @Override
    public boolean hasNext() {
        return this.current().hasNext();
    }

    @Override
    public T next() {
        this.current = this.current();
        return this.current.next();
    }

    @Override
    public void remove() {
        this.current.remove();
    }

    public void push(Iterator<T> iter) {
        this.list.addLast(iter);
    }

    public Iterator<T> pop() {
        return this.list.isEmpty() ? null : this.list.removeLast();
    }
}

