/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.assembler.tasks;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.assembler.internal.DefaultAssembleSpec;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.StaleOutputCleaner;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.compilespec.AssembleSpec;
import org.gradle.work.DisableCachingByDefault;

@Incubating
@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class Assemble
extends DefaultTask {
    private ConfigurableFileCollection source;
    private ConfigurableFileCollection includes;
    private final Property<NativePlatform> targetPlatform;
    private final Property<NativeToolChain> toolChain;
    private File objectFileDir;
    private List<String> assemblerArgs;

    @Inject
    public Assemble() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.source = this.getProject().files(new Object[0]);
        this.includes = this.getProject().files(new Object[0]);
        this.targetPlatform = objectFactory.property(NativePlatform.class);
        this.toolChain = objectFactory.property(NativeToolChain.class);
        this.getInputs().property("outputType", (Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                NativeToolChainInternal nativeToolChain = (NativeToolChainInternal)Assemble.this.toolChain.get();
                NativePlatformInternal nativePlatform = (NativePlatformInternal)Assemble.this.targetPlatform.get();
                return NativeToolChainInternal.Identifier.identify((NativeToolChainInternal)nativeToolChain, (NativePlatformInternal)nativePlatform);
            }
        });
    }

    @Inject
    public BuildOperationLoggerFactory getOperationLoggerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator takes care of injection");
    }

    @TaskAction
    public void assemble() {
        BuildOperationLogger operationLogger = this.getOperationLoggerFactory().newOperationLogger(this.getName(), this.getTemporaryDir());
        boolean cleanedOutputs = StaleOutputCleaner.cleanOutputs((Deleter)this.getDeleter(), (Iterable)this.getOutputs().getPreviousOutputFiles(), (File)this.getObjectFileDir());
        DefaultAssembleSpec spec = new DefaultAssembleSpec();
        spec.setTempDir(this.getTemporaryDir());
        spec.setObjectFileDir(this.getObjectFileDir());
        spec.source((Iterable<File>)this.getSource());
        spec.include((Iterable<File>)this.getIncludes());
        spec.args(this.getAssemblerArgs());
        spec.setOperationLogger(operationLogger);
        NativeToolChainInternal nativeToolChain = (NativeToolChainInternal)this.toolChain.get();
        NativePlatformInternal nativePlatform = (NativePlatformInternal)this.targetPlatform.get();
        Compiler compiler = nativeToolChain.select(nativePlatform).newCompiler(AssembleSpec.class);
        WorkResult result = BuildOperationLoggingCompilerDecorator.wrap((Compiler)compiler).execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork() || cleanedOutputs);
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    public void source(Object sourceFiles) {
        this.source.from(new Object[]{sourceFiles});
    }

    @Input
    public List<String> getAssemblerArgs() {
        return this.assemblerArgs;
    }

    public void setAssemblerArgs(List<String> assemblerArgs) {
        this.assemblerArgs = assemblerArgs;
    }

    @Internal
    public Property<NativeToolChain> getToolChain() {
        return this.toolChain;
    }

    @Nested
    public Property<NativePlatform> getTargetPlatform() {
        return this.targetPlatform;
    }

    @OutputDirectory
    public File getObjectFileDir() {
        return this.objectFileDir;
    }

    public void setObjectFileDir(File objectFileDir) {
        this.objectFileDir = objectFileDir;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public ConfigurableFileCollection getIncludes() {
        return this.includes;
    }

    public void includes(Object includeRoots) {
        this.includes.from(new Object[]{includeRoots});
    }
}

