/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentDetailsSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedComponentVisitor;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

@ThreadSafe
public class ThisBuildOnlyComponentDetailsSerializer
implements ComponentDetailsSerializer {
    private final Long2ObjectMap<ComponentGraphResolveState> components = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final Serializer<ComponentIdentifier> componentIdSerializer = new ComponentIdentifierSerializer();
    private final Serializer<ModuleVersionIdentifier> moduleVersionIdSerializer;

    public ThisBuildOnlyComponentDetailsSerializer(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.moduleVersionIdSerializer = new ModuleVersionIdentifierSerializer(moduleIdentifierFactory);
    }

    @Override
    public void writeComponentDetails(ComponentGraphResolveState component, boolean requireAllVariants, Encoder encoder) throws Exception {
        if (component.isAdHoc()) {
            this.writeComponentData(component, encoder);
        } else {
            this.writeComponentReference(component, requireAllVariants, encoder);
        }
    }

    private void writeComponentReference(ComponentGraphResolveState component, boolean requireAllVariants, Encoder encoder) throws IOException {
        encoder.writeBoolean(false);
        long instanceId = component.getInstanceId();
        this.components.putIfAbsent(instanceId, (Object)component);
        encoder.writeSmallLong(instanceId);
        encoder.writeBoolean(requireAllVariants);
    }

    private void writeComponentData(ComponentGraphResolveState component, Encoder encoder) throws Exception {
        encoder.writeBoolean(true);
        this.componentIdSerializer.write(encoder, (Object)component.getId());
        this.moduleVersionIdSerializer.write(encoder, (Object)component.getMetadata().getModuleVersionId());
    }

    @Override
    public void readComponentDetails(Decoder decoder, ResolvedComponentVisitor visitor) throws Exception {
        if (decoder.readBoolean()) {
            this.readComponentData(decoder, visitor);
        } else {
            this.readComponentReference(decoder, visitor);
        }
    }

    private void readComponentReference(Decoder decoder, ResolvedComponentVisitor visitor) throws IOException {
        long instanceId = decoder.readSmallLong();
        ComponentGraphResolveState component = (ComponentGraphResolveState)this.components.get(instanceId);
        if (component == null) {
            throw new IllegalStateException("No component with id " + instanceId + " found.");
        }
        visitor.visitComponentDetails(component.getId(), component.getMetadata().getModuleVersionId());
        Object availableVariants = decoder.readBoolean() ? component.getAllSelectableVariantResults() : ImmutableList.of();
        visitor.visitComponentVariants((List<ResolvedVariantResult>)availableVariants);
    }

    private void readComponentData(Decoder decoder, ResolvedComponentVisitor visitor) throws Exception {
        ComponentIdentifier componentIdentifier = (ComponentIdentifier)this.componentIdSerializer.read(decoder);
        ModuleVersionIdentifier moduleVersionIdentifier = (ModuleVersionIdentifier)this.moduleVersionIdSerializer.read(decoder);
        visitor.visitComponentDetails(componentIdentifier, moduleVersionIdentifier);
        visitor.visitComponentVariants((List<ResolvedVariantResult>)ImmutableList.of());
    }
}

