/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.AbstractTerminal;
import net.rubygrapefruit.platform.internal.AbstractTerminals;
import net.rubygrapefruit.platform.internal.PosixTerminalInput;
import net.rubygrapefruit.platform.internal.TerminfoTerminal;
import net.rubygrapefruit.platform.internal.jni.NativeLibraryFunctions;
import net.rubygrapefruit.platform.internal.jni.PosixTerminalFunctions;
import net.rubygrapefruit.platform.terminal.TerminalInput;
import net.rubygrapefruit.platform.terminal.Terminals;

public class PosixTerminals
extends AbstractTerminals {
    public boolean isTerminal(Terminals.Output output) {
        switch (output) {
            case Stdout: {
                return PosixTerminalFunctions.isatty(NativeLibraryFunctions.STDOUT);
            }
            case Stderr: {
                return PosixTerminalFunctions.isatty(NativeLibraryFunctions.STDERR);
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isTerminalInput() throws NativeException {
        return PosixTerminalFunctions.isatty(NativeLibraryFunctions.STDIN);
    }

    protected TerminalInput createInput() {
        return new PosixTerminalInput();
    }

    protected AbstractTerminal createTerminal(Terminals.Output output) {
        return new TerminfoTerminal(output);
    }
}

