/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.designs.Infinity2;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.tool.generator.flag.FlagConstructorData;
import com.sun.electric.tool.generator.flag.FlagDesign;
import com.sun.electric.tool.generator.flag.designs.Infinity2.Infinity2Config;
import com.sun.electric.tool.generator.flag.router.ToConnect;
import com.sun.electric.tool.generator.layout.AbutRouter;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.util.math.Orientation;
import java.util.ArrayList;
import java.util.List;

public class InstFifoAll
extends FlagDesign {
    private final double DEF_SIZE = Double.POSITIVE_INFINITY;
    private final double LEFT_COL_X = -1224.0;
    private final double RIGHT_COL_X = 1224.0;
    private final double START_COL_Y = -504.0;
    private final double Y_PITCH = 144.0;
    private List<NodeInst> lCol = new ArrayList<NodeInst>();
    private List<NodeInst> rCol = new ArrayList<NodeInst>();
    private NodeInst ctl;

    private Library findLibrary(String nm) {
        Library l = Library.findLibrary(nm);
        if (l == null) {
            String errMsg = "Can't find Library: " + nm;
            InstFifoAll.prln(errMsg);
            throw new RuntimeException(errMsg);
        }
        return l;
    }

    private Cell findCell(Library lib, String cellNm) {
        Cell c = lib.findNodeProto(cellNm);
        if (c == null) {
            String errMsg = "Can't find cell: " + cellNm + " in library: " + lib.getName();
            InstFifoAll.prln(errMsg);
            throw new RuntimeException(errMsg);
        }
        return c;
    }

    private PortInst findPortInst(NodeInst ni, String portNm) {
        PortInst pi = ni.findPortInst(portNm);
        if (pi == null) {
            String errMsg = "NodeInst: " + ni.describe(false) + " has no PortInst named: " + portNm;
            InstFifoAll.prln(errMsg);
            throw new RuntimeException(errMsg);
        }
        return pi;
    }

    private void stackInsts(List<NodeInst> layInsts) {
        NodeInst prev = null;
        for (NodeInst me : layInsts) {
            if (prev != null) {
                LayoutLib.alignCorners(prev, LayoutLib.Corner.TL, me, LayoutLib.Corner.BL, 0.0, 0.0);
            }
            prev = me;
        }
    }

    private void createLayInsts(Cell layCell) {
        EditingPreferences ep = this.getEditingPreferences();
        Library registersK = this.findLibrary("registersK");
        Cell instReg14 = this.findCell(registersK, "instReg14{lay}");
        Cell instReg12 = this.findCell(registersK, "instReg12{lay}");
        Cell instReg14x2 = this.findCell(registersK, "instReg14x2{lay}");
        Cell instReg12x2 = this.findCell(registersK, "instReg12x2{lay}");
        Cell instMerge14 = this.findCell(registersK, "instMerge14{lay}");
        Cell instMerge12 = this.findCell(registersK, "instMerge12{lay}");
        Library fifosK = this.findLibrary("fifosK");
        Cell instFifoCont = fifosK.findNodeProto("instFifoCont{lay}");
        this.lCol.add(LayoutLib.newNodeInst(instReg14, ep, 0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, layCell));
        this.rCol.add(LayoutLib.newNodeInst(instReg12, ep, 0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, layCell));
        for (int i = 0; i < 6; ++i) {
            this.lCol.add(LayoutLib.newNodeInst(instReg14x2, ep, 0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, layCell));
            this.rCol.add(LayoutLib.newNodeInst(instReg12x2, ep, 0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, layCell));
        }
        NodeInst m = LayoutLib.newNodeInst(instMerge14, ep, 0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, layCell);
        m.modifyInstance(0.0, 0.0, 0.0, 0.0, Orientation.Y);
        this.lCol.add(m);
        m = LayoutLib.newNodeInst(instMerge12, ep, 0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, layCell);
        m.modifyInstance(0.0, 0.0, 0.0, 0.0, Orientation.Y);
        this.rCol.add(m);
        this.lCol.add(LayoutLib.newNodeInst(instReg14, ep, 0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, layCell));
        this.rCol.add(LayoutLib.newNodeInst(instReg12, ep, 0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, layCell));
        this.ctl = LayoutLib.newNodeInst(instFifoCont, ep, 0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, layCell);
    }

    private void placeLayInsts() {
        LayoutLib.alignCorners(this.ctl, LayoutLib.Corner.BL, this.lCol.get(0), LayoutLib.Corner.BR, 0.0, 0.0);
        LayoutLib.alignCorners(this.ctl, LayoutLib.Corner.BR, this.rCol.get(0), LayoutLib.Corner.BL, 0.0, 0.0);
        this.stackInsts(this.lCol);
        this.stackInsts(this.rCol);
    }

    private void abutRoute(EditingPreferences ep) {
        ArrayList<ArcProto> layers = new ArrayList<ArcProto>();
        layers.add(this.tech().m2());
        for (NodeInst ni : this.lCol) {
            AbutRouter.abutRouteLeftRight(ni, this.ctl, 10.0, layers, ep);
        }
        for (NodeInst ni : this.rCol) {
            AbutRouter.abutRouteLeftRight(this.ctl, ni, 10.0, layers, ep);
        }
    }

    private void connectBus(List<ToConnect> toConns, int row1, String bus1, int row2, String bus2) {
        ToConnect net;
        int i;
        for (i = 1; i <= 14; ++i) {
            net = new ToConnect();
            net.addPortInst(this.findPortInst(this.lCol.get(row1), bus1 + "[" + i + "]"));
            net.addPortInst(this.findPortInst(this.lCol.get(row2), bus2 + "[" + i + "]"));
            toConns.add(net);
        }
        for (i = 1; i <= 12; ++i) {
            net = new ToConnect();
            net.addPortInst(this.findPortInst(this.rCol.get(row1), bus1 + "[" + i + "]"));
            net.addPortInst(this.findPortInst(this.rCol.get(row2), bus2 + "[" + i + "]"));
            toConns.add(net);
        }
    }

    private List<ToConnect> createNetlist() {
        ArrayList<ToConnect> toConns = new ArrayList<ToConnect>();
        this.connectBus(toConns, 0, "out", 3, "inX");
        this.connectBus(toConns, 3, "outX", 3, "inY");
        this.connectBus(toConns, 3, "outY", 6, "inY");
        this.connectBus(toConns, 6, "outY", 6, "inX");
        this.connectBus(toConns, 6, "outX", 7, "inA");
        this.connectBus(toConns, 7, "out", 5, "inY");
        this.connectBus(toConns, 5, "outY", 4, "inY");
        this.connectBus(toConns, 4, "outY", 2, "inY");
        this.connectBus(toConns, 2, "outY", 1, "inY");
        this.connectBus(toConns, 1, "outY", 1, "inX");
        this.connectBus(toConns, 1, "outX", 2, "inX");
        this.connectBus(toConns, 2, "outX", 4, "inX");
        this.connectBus(toConns, 4, "outX", 5, "inX");
        this.connectBus(toConns, 5, "outX", 8, "in");
        return toConns;
    }

    public InstFifoAll(FlagConstructorData data) {
        super(Infinity2Config.CONFIG, data);
        this.createLayInsts(data.getLayoutCell());
        this.placeLayInsts();
        this.addEssentialBounds(data.getLayoutCell());
        this.abutRoute(data.getEditingPreferences());
        List<ToConnect> toConns = this.createNetlist();
        this.routeSignalsSog(toConns, data.getEditingPreferences(), data.getSOGPrefs());
        this.reexportPowerGround(data.getLayoutCell());
        this.addNccVddGndExportsConnectedByParent(data.getLayoutCell());
    }
}

