/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import java.util.HashMap;
import java.util.Map;

public class Bipolar
extends Part {
    private static final BipolarPinTypeCache TYPE_TO_PINTYPE_ARRAY = new BipolarPinTypeCache();
    private double area;
    private static final int[] PIN_COEFFS = new int[]{Primes.get(1), Primes.get(2), Primes.get(3)};

    @Override
    public PinType getPinTypeOfNthPin(int n) {
        BipolarPinType[] pinTypeArray = TYPE_TO_PINTYPE_ARRAY.get(this.type());
        return pinTypeArray[n];
    }

    private Bipolar(PrimitiveNode.Function np, NccNameProxy.PartNameProxy name, double area, Wire[] pins) {
        super(name, np, pins);
        Job.error(np == null, "null type?");
        this.area = area;
    }

    private boolean samePinsAs(Bipolar b) {
        Job.error(b.pins.length != this.pins.length, "different # pins?");
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] == b.pins[i]) continue;
            return false;
        }
        return true;
    }

    public Bipolar(PrimitiveNode.Function np, NccNameProxy.PartNameProxy name, double area, Wire emit, Wire base, Wire coll) {
        this(np, name, area, new Wire[]{emit, base, coll});
    }

    public double getArea() {
        return this.area;
    }

    @Override
    public int[] getPinCoeffs() {
        return PIN_COEFFS;
    }

    @Override
    public Integer hashCodeForParallelMerge() {
        int hc = this.getClass().hashCode();
        for (int i = 0; i < this.pins.length; ++i) {
            hc += this.pins[i].hashCode() * PIN_COEFFS[i];
        }
        return new Integer(hc += this.type().hashCode());
    }

    @Override
    public boolean parallelMerge(Part p, NccOptions nccOpt) {
        if (!(p instanceof Bipolar)) {
            return false;
        }
        Bipolar b = (Bipolar)p;
        if (this == b) {
            return false;
        }
        if (this.type() != b.type()) {
            return false;
        }
        if (!this.samePinsAs(b)) {
            return false;
        }
        this.area += b.area;
        b.setDeleted();
        return true;
    }

    @Override
    public int typeCode() {
        return this.type().ordinal();
    }

    @Override
    public String typeString() {
        return this.type().getShortName();
    }

    @Override
    public String valueDescription() {
        return "A=" + NccUtils.round(this.area, 2);
    }

    @Override
    public String connectionDescription(int n) {
        return "E=" + this.pins[0].getName() + " B=" + this.pins[1].getName() + " C=" + this.pins[2].getName();
    }

    @Override
    public String connectionDescription(Wire w) {
        String s2 = "";
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            if (s2.length() != 0) {
                s2 = s2 + ",";
            }
            s2 = i == 0 ? s2 + "E" : (i == 1 ? s2 + "B" : s2 + "C");
        }
        return s2;
    }

    private static class BipolarPinTypeCache {
        private Map<PrimitiveNode.Function, BipolarPinType[]> typeToPinTypeArray = new HashMap<PrimitiveNode.Function, BipolarPinType[]>();

        private BipolarPinTypeCache() {
        }

        synchronized BipolarPinType[] get(PrimitiveNode.Function f) {
            BipolarPinType[] bpt = this.typeToPinTypeArray.get((Object)f);
            if (bpt == null) {
                bpt = new BipolarPinType[3];
                for (int p = 0; p < 3; ++p) {
                    bpt[p] = new BipolarPinType(f, p);
                }
                this.typeToPinTypeArray.put(f, bpt);
            }
            return bpt;
        }
    }

    private static class BipolarPinType
    implements PinType {
        private final PrimitiveNode.Function np;
        private final int pinIndex;
        private static final String[] PIN_NAMES = new String[]{"emitter", "base", "collector"};

        @Override
        public String description() {
            return this.np.getShortName() + " " + PIN_NAMES[this.pinIndex];
        }

        public BipolarPinType(PrimitiveNode.Function np, int pinIndex) {
            Job.error(np == null, "null type?");
            this.np = np;
            this.pinIndex = pinIndex;
        }
    }
}

