/* arcogdesc.c was originally generated by the autoSql program, which also 
 * generated arcogdesc.h and arcogdesc.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "arcogdesc.h"


void arcogdescStaticLoad(char **row, struct arcogdesc *ret)
/* Load a row from arcogdesc table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
safecpy(ret->code, sizeof(ret->code), row[1]);
ret->description = row[2];
}

struct arcogdesc *arcogdescLoad(char **row)
/* Load a arcogdesc from row fetched with select * from arcogdesc
 * from database.  Dispose of this with arcogdescFree(). */
{
struct arcogdesc *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
safecpy(ret->code, sizeof(ret->code), row[1]);
ret->description = cloneString(row[2]);
return ret;
}

struct arcogdesc *arcogdescLoadAll(char *fileName) 
/* Load all arcogdesc from a whitespace-separated file.
 * Dispose of this with arcogdescFreeList(). */
{
struct arcogdesc *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = arcogdescLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct arcogdesc *arcogdescLoadAllByChar(char *fileName, char chopper) 
/* Load all arcogdesc from a chopper separated file.
 * Dispose of this with arcogdescFreeList(). */
{
struct arcogdesc *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = arcogdescLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct arcogdesc *arcogdescCommaIn(char **pS, struct arcogdesc *ret)
/* Create a arcogdesc out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new arcogdesc */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->code, sizeof(ret->code));
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void arcogdescFree(struct arcogdesc **pEl)
/* Free a single dynamically allocated arcogdesc such as created
 * with arcogdescLoad(). */
{
struct arcogdesc *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->description);
freez(pEl);
}

void arcogdescFreeList(struct arcogdesc **pList)
/* Free a list of dynamically allocated arcogdesc's */
{
struct arcogdesc *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    arcogdescFree(&el);
    }
*pList = NULL;
}

void arcogdescOutput(struct arcogdesc *el, FILE *f, char sep, char lastSep) 
/* Print out arcogdesc.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->code);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

