/* bed6FloatScore.c was originally generated by the autoSql program, which also 
 * generated bed6FloatScore.h and bed6FloatScore.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "bed6FloatScore.h"


void bed6FloatScoreStaticLoad(char **row, struct bed6FloatScore *ret)
/* Load a row from bed6FloatScore table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = atof(row[4]);
strcpy(ret->strand, row[5]);
}

struct bed6FloatScore *bed6FloatScoreLoad(char **row)
/* Load a bed6FloatScore from row fetched with select * from bed6FloatScore
 * from database.  Dispose of this with bed6FloatScoreFree(). */
{
struct bed6FloatScore *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = atof(row[4]);
strcpy(ret->strand, row[5]);
return ret;
}

struct bed6FloatScore *bed6FloatScoreLoadAll(char *fileName) 
/* Load all bed6FloatScore from a whitespace-separated file.
 * Dispose of this with bed6FloatScoreFreeList(). */
{
struct bed6FloatScore *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = bed6FloatScoreLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bed6FloatScore *bed6FloatScoreLoadAllByChar(char *fileName, char chopper) 
/* Load all bed6FloatScore from a chopper separated file.
 * Dispose of this with bed6FloatScoreFreeList(). */
{
struct bed6FloatScore *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = bed6FloatScoreLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bed6FloatScore *bed6FloatScoreCommaIn(char **pS, struct bed6FloatScore *ret)
/* Create a bed6FloatScore out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bed6FloatScore */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlFloatComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
*pS = s;
return ret;
}

void bed6FloatScoreFree(struct bed6FloatScore **pEl)
/* Free a single dynamically allocated bed6FloatScore such as created
 * with bed6FloatScoreLoad(). */
{
struct bed6FloatScore *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freez(pEl);
}

void bed6FloatScoreFreeList(struct bed6FloatScore **pList)
/* Free a list of dynamically allocated bed6FloatScore's */
{
struct bed6FloatScore *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    bed6FloatScoreFree(&el);
    }
*pList = NULL;
}

void bed6FloatScoreOutput(struct bed6FloatScore *el, FILE *f, char sep, char lastSep) 
/* Print out bed6FloatScore.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

