/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.xmind.core.ISheet;
import org.xmind.core.ISheetComponent;
import org.xmind.core.IWorkbook;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.tree.TreeRootPart;
import org.xmind.ui.internal.audionotes.AudioNotesViewer;
import org.xmind.ui.internal.mindmap.filtering.FilterSection;
import org.xmind.ui.internal.mindmap.filtering.FilterViewer;
import org.xmind.ui.internal.mindmap.filtering.LabelFilterSection;
import org.xmind.ui.internal.mindmap.filtering.MarkerFilterSection;
import org.xmind.ui.internal.outline.MindMapTreeViewer;
import org.xmind.ui.internal.presentation.IPresentationPage;
import org.xmind.ui.internal.presentation.PresentationMessages;
import org.xmind.ui.internal.presentation.PresentationWindow;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class SideBar {
    public static final int PREF_WIDTH = 240;
    private PresentationWindow window;
    private Composite container;
    private FilterViewer filterViewer;
    private AudioNotesViewer audioNotesViewer;

    public SideBar(PresentationWindow window) {
        this.window = window;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setBackground(ColorUtils.getColor((String)"#CBCBCB"));
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 7;
        this.container.setLayout((Layout)layout);
        this.createOutlinePart(this.container);
        this.createFilterPart(this.container);
        this.createAudioNotesPart(this.container);
        this.createButtonBar(this.container);
        this.container.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                IAction action;
                if (e.detail == 2 && (action = SideBar.this.window.getActionRegistry().getAction("org.xmind.ui.presentation.action.sideBar")) != null) {
                    action.run();
                    e.doit = false;
                }
            }
        });
    }

    private void createButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setBackground(parent.getBackground());
        buttonBar.setLayoutData((Object)new GridData(0x1000000, 0x1000008, false, false));
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 10;
        layout.marginHeight = 15;
        layout.marginWidth = 15;
        buttonBar.setLayout((Layout)layout);
        Button closeButton = new Button(buttonBar, 8);
        closeButton.setText(PresentationMessages.HideSidebar_text);
        closeButton.setBackground(buttonBar.getBackground());
        closeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SideBar.this.hideSidebar();
            }
        });
        GridData layoutData = new GridData(0x1000000, 0x1000000, false, false);
        layoutData.widthHint = 200;
        closeButton.setLayoutData((Object)layoutData);
    }

    private void hideSidebar() {
        IAction action = this.window.getActionRegistry().getAction("org.xmind.ui.presentation.action.sideBar");
        if (action != null) {
            action.run();
        }
    }

    private void createOutlinePart(Composite parent) {
        Composite section = this.createTitledSection(parent, PresentationMessages.Outline_title, true, -1);
        final MindMapTreeViewer outlineViewer = new MindMapTreeViewer();
        outlineViewer.getProperties().set("PROP_HEADER_VISIBLE", false);
        outlineViewer.setPartFactory(MindMapUI.getMindMapTreePartFactory());
        outlineViewer.setRootPart((IRootPart)new TreeRootPart());
        outlineViewer.createControl(section, 4);
        outlineViewer.setInput(this.window.getSourceEditor().getAdapter(IWorkbook.class));
        outlineViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        outlineViewer.getControl().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Tree tree = outlineViewer.getTree();
                TreeItem item = tree.getItem(new Point(event.x, event.y));
                if (item != null && item.getData() instanceof IPart) {
                    SideBar.this.goToPart((IPart)item.getData());
                }
            }
        });
    }

    private void goToPart(IPart part) {
        ISheet sheet = this.findSheet(part);
        if (sheet == null) {
            return;
        }
        this.goToSheet(sheet);
        IPresentationPage page = this.window.getCurrentPage();
        if (page != null) {
            page.getViewer().setSelection((ISelection)new StructuredSelection(part.getModel()), true);
        }
    }

    private void goToSheet(ISheet sheet) {
        int i = 0;
        while (i < this.window.getPageCount()) {
            IPresentationPage page = this.window.getPage(i);
            if (sheet.equals(page.getInput().getSheet())) {
                this.window.setCurrentPage(i);
                return;
            }
            ++i;
        }
    }

    private ISheet findSheet(IPart part) {
        if (part.getModel() instanceof ISheet) {
            return (ISheet)part.getModel();
        }
        if (part.getModel() instanceof ISheetComponent) {
            return ((ISheetComponent)part.getModel()).getOwnedSheet();
        }
        return (ISheet)part.getAdapter(ISheet.class);
    }

    private void createFilterPart(Composite parent) {
        Composite section = this.createTitledSection(parent, PresentationMessages.Filter_title, false, 200);
        this.filterViewer = new FilterViewer(false);
        MarkerFilterSection markerSection = new MarkerFilterSection(0);
        markerSection.setSectionStyle(4096);
        this.filterViewer.addSection((FilterSection)markerSection);
        LabelFilterSection labelSection = new LabelFilterSection(0);
        labelSection.setSectionStyle(4096);
        this.filterViewer.addSection((FilterSection)labelSection);
        this.filterViewer.createControl(section);
        this.filterViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createAudioNotesPart(Composite parent) {
        Composite section = this.createTitledSection(parent, PresentationMessages.AudioNotes_title, false, -1);
        this.audioNotesViewer = new AudioNotesViewer(false);
        this.audioNotesViewer.createControl(section);
        this.audioNotesViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.audioNotesViewer.update(31, null);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SideBar.this.audioNotesViewer != null) {
                    SideBar.this.audioNotesViewer.dispose();
                    SideBar.this.audioNotesViewer = null;
                }
            }
        });
    }

    public void setSelection(IPresentationPage page, ISelection selection) {
        if (this.filterViewer != null) {
            this.filterViewer.setContributingViewer(page == null ? null : page.getViewer());
        }
        if (this.audioNotesViewer != null) {
            this.audioNotesViewer.setSelection(selection, (ISelectionProvider)page.getViewer());
        }
    }

    protected Composite createTitledSection(Composite parent, String text, boolean grabVertical, int height) {
        Composite section = new Composite(parent, 0);
        section.setBackground(parent.getBackground());
        section.setLayoutData((Object)new GridData(4, 4, true, grabVertical));
        if (height > 0) {
            ((GridData)section.getLayoutData()).minimumHeight = height;
            ((GridData)section.getLayoutData()).heightHint = height;
        }
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        section.setLayout((Layout)layout);
        this.createSectionTitle(section, text);
        return section;
    }

    protected void createSectionTitle(Composite parent, String text) {
        Composite titleBar = new Composite(parent, 0);
        titleBar.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        titleBar.setLayout((Layout)layout);
        titleBar.setLayoutData((Object)new GridData(4, 4, true, false));
        Label titleLabel = new Label(titleBar, 0x1000000);
        titleLabel.setText(text);
        titleLabel.setFont(FontUtils.getBold((String)"org.eclipse.jface.defaultfont", (int)14));
        titleLabel.setBackground(titleBar.getBackground());
        titleLabel.setForeground(titleBar.getDisplay().getSystemColor(30));
        titleLabel.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    public Control getControl() {
        return this.container;
    }
}

