/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editor.DialogPane;
import org.xmind.ui.mindmap.MindMapUI;

public class EncryptionDailogPane
extends DialogPane {
    private Text oldPasswordInputBox;
    private Text newPasswordInputBox;
    private Text verifyNewPasswordInputBox;
    private Label oldPasswordVerificationLabel;
    private Label newPasswordVerificationLabel;
    private Image doneIcon;
    private Image undoneIcon;
    private Image blankIcon;
    private String password;

    private Image getDoneIcon() {
        ImageDescriptor img;
        if (this.getContainer() == null || this.getContainer().isDisposed()) {
            return null;
        }
        if ((this.doneIcon == null || this.doneIcon.isDisposed()) && (img = MindMapUI.getImages().get("step_done.gif", true)) != null) {
            this.doneIcon = img.createImage((Device)this.getContainer().getDisplay());
        }
        return this.doneIcon;
    }

    private Image getUndoneIcon() {
        ImageDescriptor img;
        if (this.getContainer() == null || this.getContainer().isDisposed()) {
            return null;
        }
        if ((this.undoneIcon == null || this.undoneIcon.isDisposed()) && (img = MindMapUI.getImages().get("step_done.gif", false)) != null) {
            this.undoneIcon = img.createImage((Device)this.getContainer().getDisplay());
        }
        return this.undoneIcon;
    }

    private Image getBlankIcon() {
        ImageDescriptor img;
        if (this.getContainer() == null || this.getContainer().isDisposed()) {
            return null;
        }
        if ((this.blankIcon == null || this.blankIcon.isDisposed()) && (img = MindMapUI.getImages().get("icons/misc/blank.gif")) != null) {
            this.blankIcon = img.createImage((Device)this.getContainer().getDisplay());
        }
        return this.blankIcon;
    }

    @Override
    public void dispose() {
        if (this.doneIcon != null) {
            this.doneIcon.dispose();
            this.doneIcon = null;
        }
        if (this.blankIcon != null) {
            this.blankIcon.dispose();
            this.blankIcon = null;
        }
        super.dispose();
    }

    @Override
    protected Control createDialogContents(Composite parent) {
        Composite composite = (Composite)super.createDialogContents(parent);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 20;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createMessageArea(composite);
        this.createPasswordArea(composite);
        this.verify();
        return composite;
    }

    private void createMessageArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setBackground(parent.getBackground());
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        area.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 10;
        area.setLayout((Layout)gridLayout);
        this.createMessageIcon(area);
        this.createMessageBoard(area);
    }

    private void createMessageIcon(Composite parent) {
        Label iconLabel = new Label(parent, 0);
        iconLabel.setBackground(parent.getBackground());
        iconLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Image image = this.getMessageIcon((Control)iconLabel);
        iconLabel.setImage(image);
    }

    private Image getMessageIcon(Control control) {
        if (control == null) {
            return null;
        }
        ImageDescriptor image = MindMapUI.getImages().get("lock.gif", true);
        if (image != null) {
            return image.createImage((Device)control.getDisplay());
        }
        return null;
    }

    private void createMessageBoard(Composite parent) {
        Text messageBoard = new Text(parent, 74);
        messageBoard.setBackground(parent.getBackground());
        this.applyFont((Control)messageBoard);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        messageBoard.setLayoutData((Object)gridData);
        messageBoard.setText(MindMapMessages.EncryptDialogPane_board_message);
    }

    private void createPasswordArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setBackground(parent.getBackground());
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        area.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 3;
        area.setLayout((Layout)gridLayout);
        if (this.hasPassword()) {
            this.createOldPasswordInputBox(area);
        }
        this.createNewPasswordInputBox(area);
        this.createVerifyPasswordInputBox(area);
        Listener verifyListener = new Listener(){

            public void handleEvent(Event event) {
                EncryptionDailogPane.this.verify();
            }
        };
        if (this.oldPasswordInputBox != null) {
            this.oldPasswordInputBox.addListener(24, verifyListener);
        }
        this.newPasswordInputBox.addListener(24, verifyListener);
        this.verifyNewPasswordInputBox.addListener(24, verifyListener);
    }

    private void createOldPasswordInputBox(Composite parent) {
        Label assistMessageBox = new Label(parent, 64);
        assistMessageBox.setBackground(parent.getBackground());
        assistMessageBox.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)assistMessageBox.getLayoutData()).horizontalSpan = 3;
        assistMessageBox.setText(MindMapMessages.EncryptDialogPane_assist_message);
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(MindMapMessages.EncryptDialogPane_oldpassword_text);
        label.setBackground(parent.getBackground());
        this.applyFont((Control)label);
        this.oldPasswordInputBox = new Text(parent, 0x400804);
        this.applyFont((Control)this.oldPasswordInputBox);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        this.oldPasswordInputBox.setLayoutData((Object)gridData);
        this.hookText(this.oldPasswordInputBox);
        this.addRefreshDefaultButtonListener((Control)this.oldPasswordInputBox);
        this.addTriggerDefaultButtonListener((Control)this.oldPasswordInputBox, 14);
        this.oldPasswordVerificationLabel = new Label(parent, 0);
        this.oldPasswordVerificationLabel.setBackground(parent.getBackground());
        this.oldPasswordVerificationLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.oldPasswordVerificationLabel.setImage(this.getDoneIcon());
        Label sep = new Label(parent, 0);
        sep.setBackground(parent.getBackground());
        sep.setLayoutData((Object)new GridData(4, 4, true, false));
        ((GridData)sep.getLayoutData()).horizontalSpan = 3;
    }

    private void createNewPasswordInputBox(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        String text = this.oldPasswordInputBox == null ? MindMapMessages.EncryptDialogPane_password_text : MindMapMessages.EncryptDialogPane_newpassword_text;
        label.setText(text);
        label.setBackground(parent.getBackground());
        this.applyFont((Control)label);
        this.newPasswordInputBox = new Text(parent, 0x400804);
        this.applyFont((Control)this.newPasswordInputBox);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        this.newPasswordInputBox.setLayoutData((Object)gridData);
        this.hookText(this.newPasswordInputBox);
        this.addRefreshDefaultButtonListener((Control)this.newPasswordInputBox);
        this.addTriggerDefaultButtonListener((Control)this.newPasswordInputBox, 14);
        Label blankIcon = new Label(parent, 0);
        blankIcon.setBackground(parent.getBackground());
        blankIcon.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        blankIcon.setImage(this.getBlankIcon());
    }

    private void createVerifyPasswordInputBox(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(MindMapMessages.EncryptDialogPane_confirm_text);
        label.setBackground(parent.getBackground());
        this.applyFont((Control)label);
        this.verifyNewPasswordInputBox = new Text(parent, 0x400804);
        this.applyFont((Control)this.verifyNewPasswordInputBox);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        this.verifyNewPasswordInputBox.setLayoutData((Object)gridData);
        this.hookText(this.verifyNewPasswordInputBox);
        this.addRefreshDefaultButtonListener((Control)this.verifyNewPasswordInputBox);
        this.addTriggerDefaultButtonListener((Control)this.verifyNewPasswordInputBox, 14);
        this.newPasswordVerificationLabel = new Label(parent, 0);
        this.newPasswordVerificationLabel.setBackground(parent.getBackground());
        this.newPasswordVerificationLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.newPasswordVerificationLabel.setImage(this.getDoneIcon());
    }

    @Override
    protected void createButtonsForButtonBar(Composite buttonBar) {
        this.createButton(buttonBar, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(buttonBar, 1, IDialogConstants.CANCEL_LABEL, false);
        this.setOKButtonEnabled(false);
    }

    private void setOKButtonEnabled(boolean enabled) {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(enabled);
        }
    }

    private void verify() {
        boolean oldPasswordVerified = false;
        if (!this.hasPassword()) {
            oldPasswordVerified = !"".equals(this.newPasswordInputBox.getText());
        } else if (this.oldPasswordInputBox != null) {
            oldPasswordVerified = this.testsPassword(this.oldPasswordInputBox.getText());
            this.oldPasswordVerificationLabel.setImage(oldPasswordVerified ? this.getDoneIcon() : this.getUndoneIcon());
        }
        boolean newPasswordVerified = (this.oldPasswordInputBox != null || !"".equals(this.newPasswordInputBox.getText())) && this.newPasswordInputBox.getText().equals(this.verifyNewPasswordInputBox.getText());
        this.newPasswordVerificationLabel.setImage(newPasswordVerified ? this.getDoneIcon() : this.getUndoneIcon());
        this.setOKButtonEnabled(oldPasswordVerified && newPasswordVerified);
    }

    @Override
    protected boolean okPressed() {
        this.setPassword(this.newPasswordInputBox.getText());
        this.setReturnCode(0);
        this.close();
        return true;
    }

    protected void setPassword(String newPassword) {
        if ("".equals(newPassword)) {
            newPassword = null;
        }
        this.password = newPassword;
    }

    @Override
    protected boolean cancelPressed() {
        this.setReturnCode(1);
        this.close();
        return true;
    }

    @Override
    public void setFocus() {
        if (this.oldPasswordInputBox != null && !this.oldPasswordInputBox.isDisposed()) {
            this.oldPasswordInputBox.setFocus();
        } else if (this.newPasswordInputBox != null && !this.newPasswordInputBox.isDisposed()) {
            this.newPasswordInputBox.setFocus();
        }
    }

    protected String getPassword() {
        return this.password;
    }

    protected boolean hasPassword() {
        return false;
    }

    protected boolean testsPassword(String password) {
        return false;
    }
}

