/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.util.Arrays;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.core.ISheet;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ISourceTool;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.editor.MindMapEditor;
import org.xmind.ui.internal.tools.SheetTitleEditTool;

public class MindMapPageTitleEditor {
    private static final int MIN_EDITOR_WIDTH = 50;
    private final CTabFolder tabFolder;
    private final IGraphicalEditor editor;

    public MindMapPageTitleEditor(CTabFolder tabFolder, MindMapEditor mindmapEditor) {
        this.tabFolder = tabFolder;
        this.editor = mindmapEditor;
        this.hookControl(tabFolder);
    }

    protected void hookControl(CTabFolder tabFolder) {
        Listener eventHandler = new Listener(){

            public void handleEvent(Event event) {
                MindMapPageTitleEditor.this.doHandleEvent(event);
            }
        };
        tabFolder.addListener(8, eventHandler);
        tabFolder.addListener(3, eventHandler);
    }

    private void doHandleEvent(Event event) {
        if (event.type == 8) {
            this.startEditing(new Point(event.x, event.y));
        }
        if (event.type == 3 && this.tabFolder.isFocusControl()) {
            this.startEditing(new Point(event.x, event.y));
        }
    }

    private void startEditing(Point mouseLocation) {
        if (mouseLocation == null) {
            return;
        }
        CTabItem item = this.tabFolder.getItem(mouseLocation);
        if (item == null) {
            return;
        }
        this.startEditing(this.tabFolder.indexOf(item));
    }

    public void startEditing(int pageIndex) {
        IGraphicalEditorPage page = this.editor.getPage(pageIndex);
        if (page == null) {
            return;
        }
        IGraphicalViewer viewer = page.getViewer();
        if (viewer == null) {
            return;
        }
        EditDomain editDomain = page.getEditDomain();
        if (editDomain == null) {
            return;
        }
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet == null) {
            return;
        }
        IPart part = viewer.findPart((Object)sheet);
        if (part == null || !(part instanceof IGraphicalEditPart)) {
            return;
        }
        IGraphicalEditPart sourcePart = (IGraphicalEditPart)part;
        ITool tool = editDomain.getTool("org.xmind.ui.tool.editSheetTitle");
        if (tool == null) {
            return;
        }
        if (tool instanceof ISourceTool) {
            ((ISourceTool)tool).setSource(sourcePart);
        }
        if (tool instanceof SheetTitleEditTool) {
            CTabItem item = this.tabFolder.getItem(pageIndex);
            Rectangle itemBounds = item.getBounds();
            Rectangle editorBounds = new Rectangle(itemBounds.x, itemBounds.y, Math.max(50, itemBounds.width), itemBounds.height);
            ((SheetTitleEditTool)tool).setTextEditorParameters((Composite)this.tabFolder, editorBounds);
        }
        editDomain.setActiveTool("org.xmind.ui.tool.editSheetTitle");
        if (tool != editDomain.getActiveTool()) {
            return;
        }
        tool.handleRequest(new Request("edit").setViewer((IViewer)viewer).setTargets(Arrays.asList(sourcePart)));
    }
}

