/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.IRelayerableFigure;
import org.xmind.gef.draw2d.IRelayeredPane;
import org.xmind.gef.draw2d.ISkylightLayer;
import org.xmind.gef.draw2d.IUseTransparency;
import org.xmind.gef.draw2d.SimpleRectangleFigure;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.service.GraphicalViewerService;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.mindmap.IHighlightService;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.resources.ColorUtils;

public class HighlightService
extends GraphicalViewerService
implements ISelectionChangedListener,
IHighlightService {
    private static final int DEFAULT_ALPHA = 128;
    private List<IGraphicalPart> highlights = null;
    private IRelayeredPane relayeredPane = null;
    private ISkylightLayer highlightLayer;
    private SimpleRectangleFigure highlightRect;
    private boolean autoListenSelectionChange;
    private int alpha;

    public HighlightService(IGraphicalViewer viewer, boolean autoListenSelectionChange) {
        super(viewer);
        this.autoListenSelectionChange = autoListenSelectionChange;
    }

    protected void activate() {
        if (this.autoListenSelectionChange) {
            this.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.highlights != null && !this.highlights.isEmpty()) {
            this.addToLayer(this.highlights);
        }
    }

    protected void deactivate() {
        if (this.highlights != null && !this.highlights.isEmpty()) {
            this.removeFromLayer(this.highlights);
        }
        this.getViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    @Override
    public ISkylightLayer getHighlightLayer() {
        return this.highlightLayer;
    }

    @Override
    public void setHighlightLayer(ISkylightLayer layer) {
        this.highlightLayer = layer;
    }

    @Override
    public void setHighlightArea(Rectangle r) {
        this.setHighlightArea(r, 128);
    }

    @Override
    public void setHighlightArea(Rectangle r, int alpha) {
        this.alpha = alpha;
        SimpleRectangleFigure oldRect = this.highlightRect;
        if (this.highlightLayer != null) {
            if (this.isActive()) {
                this.highlightLayer.setSkylight(r);
                if (this.highlightLayer instanceof IUseTransparency) {
                    ((IUseTransparency)this.highlightLayer).setMainAlpha(alpha);
                }
            }
            if (r == null) {
                if (this.highlightRect != null) {
                    if (this.highlightRect.getParent() != null) {
                        this.highlightRect.getParent().remove((IFigure)this.highlightRect);
                    }
                    this.highlightRect = null;
                }
            } else {
                if (this.highlightRect == null) {
                    this.highlightRect = this.createRect();
                    if (this.isActive()) {
                        this.highlightLayer.add((IFigure)this.highlightRect);
                    }
                }
                this.highlightRect.setBounds(r);
            }
        }
        if (this.relayeredPane != null) {
            if (r != null && oldRect == null) {
                if (this.highlights != null) {
                    this.removeFromLayer(this.highlights);
                }
            } else if (r == null && oldRect != null && this.highlights != null && this.isActive()) {
                this.addToLayer(this.highlights);
            }
        }
    }

    private SimpleRectangleFigure createRect() {
        SimpleRectangleFigure fig = new SimpleRectangleFigure();
        fig.setForegroundColor(ColorUtils.getColor((String)"#00007f"));
        fig.setLineWidth(1);
        return fig;
    }

    @Override
    public Rectangle getHighlightArea() {
        return this.highlightLayer == null ? null : this.highlightLayer.getSkylight();
    }

    @Override
    public IRelayeredPane getRelayeredPane() {
        return this.relayeredPane;
    }

    @Override
    public void setRelayeredPane(IRelayeredPane layer) {
        this.relayeredPane = layer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.highlight(event.getSelection());
    }

    @Override
    public void highlight(ISelection selection) {
        this.highlight(this.collectPartsToReveal(selection), 128);
    }

    @Override
    public void highlight(ISelection selection, int alpha) {
        this.highlight(this.collectPartsToReveal(selection), alpha);
    }

    @Override
    public void highlight(List<IGraphicalPart> toHighlight) {
        this.highlight(toHighlight, 128);
    }

    @Override
    public void highlight(List<IGraphicalPart> toHighlight, int alpha) {
        this.alpha = alpha;
        this.setHighlightArea(null, alpha);
        if (this.highlights != null) {
            this.removeFromLayer(this.highlights);
            this.highlights = null;
        }
        this.highlights = toHighlight;
        if (this.highlights != null && !this.highlights.isEmpty() && this.isActive()) {
            this.addToLayer(this.highlights);
            MindMapUIPlugin.getDefault().getUsageDataCollector().increase("FilterDarkerCount");
        }
    }

    private List<IGraphicalPart> collectPartsToReveal(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            ArrayList<IGraphicalPart> list = new ArrayList<IGraphicalPart>(ss.size());
            for (Object o : ss.toList()) {
                IGraphicalPart p = this.getViewer().findGraphicalPart(o);
                if (p == null || this.exclude(p)) continue;
                list.add(p);
            }
            return list;
        }
        return null;
    }

    protected boolean exclude(IGraphicalPart part) {
        return part instanceof ISheetPart;
    }

    private void addToLayer(List<IGraphicalPart> parts) {
        if (this.relayeredPane != null) {
            if (this.relayeredPane instanceof IUseTransparency) {
                ((IUseTransparency)this.relayeredPane).setMainAlpha(this.alpha);
            }
            for (IGraphicalPart p : parts) {
                IFigure figure = p.getFigure();
                if (!(figure instanceof IRelayerableFigure)) continue;
                this.relayeredPane.addRelayerableFigure((IRelayerableFigure)figure);
            }
        }
    }

    private void removeFromLayer(List<IGraphicalPart> parts) {
        if (this.relayeredPane != null) {
            for (IGraphicalPart p : parts) {
                IFigure figure = p.getFigure();
                if (!(figure instanceof IRelayerableFigure)) continue;
                this.relayeredPane.removeRelayerableFigure((IRelayerableFigure)figure);
            }
        }
    }
}

